<?xml version="1.0"?> 
<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:results="Results" xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:map="map:java.util.Map" 
	xmlns:clinicaldata="Clinicaldata"
	exclude-result-prefixes="fn xs xsi xsl map results clinicaldata">
	<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="no"/>
		
	<xsl:template match="/clinicaldata:ClinicalData">{"patientGeneratedDataEvents": [
		<xsl:for-each select="./patients/patient/patientGeneratedDataEvents/patientGeneratedDataEvent">{
		<xsl:call-template name="patientGeneratedDataEventTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
		</xsl:for-each>
		<xsl:if test="count(./patients/patient/patientGeneratedDataEvents/patientGeneratedDataEvent) > 0 and count(./errorSection) = 1">,</xsl:if>
		<xsl:if test="count(./errorSection) = 1">
			<xsl:call-template name="errorSectionTemplate"/>
		</xsl:if>]
		}
	</xsl:template>
	
		
	<xsl:template name="patientGeneratedDataEventTemplate">
			"uniqueIdentifier":"<xsl:value-of select="uniqueIdentifier/identity"/>",
			"collectionType":"<xsl:value-of select="collectionType"/>",
			"patient":{
				"identifier":{
					"identity":"<xsl:value-of select="patient/identifier/identity"/>",
					"assigningFacility":"<xsl:value-of select="patient/identifier/assigningFacility"/>",
					"assigningAuthority":"<xsl:value-of select="patient/identifier/assigningAuthority"/>"
				}
			},
			"pgdContent":<xsl:value-of select="pgdContent"/>
	</xsl:template>
	<!-- For an unknown reason (or one I can't remember) PGD needs to check for errorId present, why this is is uncertain, 
	it seems the first when test in the choose is never true - testing for error greater than 1 - only when testing ...error/errorId >= returns true
	when the second when test is removed - all error sections are transformed as empty - this is not true with vpr 1.0 and 1.2, those transforms to not use the errorId test -->	
	<xsl:template name="errorSectionTemplate">{ "errorSection":{
		<xsl:choose>
			<xsl:when test="count(./errorSection/errors/error) >= 1">"errors":[
				<xsl:for-each select="./errorSection/errors/error">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]<xsl:if test="count(./errorSection/fatalErrors/fatalError) + count(./errorSection/warnings/warning) &gt; 0">,</xsl:if>
			</xsl:when>
			<xsl:when test="count(./errorSection/errors/errorId) >= 1">"errors":[
				<xsl:for-each select="./errorSection/errors">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]<xsl:if test="count(./errorSection/fatalErrors) + count(./errorSection/warnings) &gt; 0">,</xsl:if>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(./errorSection/fatalErrors/fatalError) >= 1">"fatalErrors":[
				<xsl:for-each select="./errorSection/fatalErrors/fatalError">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]<xsl:if test="count(./errorSection/warnings/warning) &gt; 0">,</xsl:if>
			</xsl:when>
			<xsl:when test="count(./errorSection/fatalErrors/errorId) >= 1">"fatalErrors":[
				<xsl:for-each select="./errorSection/fatalErrors">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]<xsl:if test="count(./errorSection/warnings) &gt; 0">,</xsl:if>
			</xsl:when>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="count(./errorSection/warnings/warning) >= 1">"warnings":[
				<xsl:for-each select="./errorSection/warnings/warning">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]
			</xsl:when>
			<xsl:when test="count(./errorSection/warnings/errorId) >= 1">"warnings":[
				<xsl:for-each select="./errorSection/warnings">{
					<xsl:call-template name="exceptionTemplate"/>}<xsl:if test="position() != last()">,</xsl:if>
				</xsl:for-each>]
			</xsl:when>
		</xsl:choose>}}
	</xsl:template>	
	
	<xsl:template name="exceptionTemplate">
		"exceptionMessage":"<xsl:value-of select="exceptionMessage"/>",
		"displayMessage":"<xsl:value-of select="displayMessage"/>",
		"exception":"<xsl:value-of select="exception"/>",
		"errorCode":"<xsl:value-of select="errorCode"/>",
		"errorId":"<xsl:value-of select="errorId"/>"
	</xsl:template>
	
</xsl:stylesheet>
