<?xml version="1.0"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:filter="Filter" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:map="map:java.util.Map" exclude-result-prefixes="fn xs xsi xsl map">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/requestData">
		<filter:filter vhimVersion="Vhim_4_00" xmlns:filter="Filter">
			<filterId>
				<xsl:value-of select="filterId"/>
			</filterId>
			<clientName>
				<xsl:value-of select="clientName"/>
			</clientName>
			<clientRequestInitiationTime>
				<!-- xsl:value-of select="current-dateTime()"/-->
				<xsl:value-of select="clientRequestInitiationTime"/>
			</clientRequestInitiationTime>
			<patients>
				<xsl:choose>
					<xsl:when test="patientId != ''">
						<NationalId>
							<xsl:value-of select="patientId"/>
						</NationalId>
						<xsl:for-each select="excludedId">
								<excludeIdentifiers>
									<xsl:if test="excludedAssigningAuthority != ''">
										<assigningAuthority>
											<xsl:value-of select="excludedAssigningAuthority"/>
										</assigningAuthority>
									</xsl:if>
									<xsl:if test="excludedAssigningFacility != ''">
										<assigningFacility>
											<xsl:value-of select="excludedAssigningFacility"/>
										</assigningFacility>
									</xsl:if>
									<xsl:if test="excludedIdentifier != ''">
										<identity>
											<xsl:value-of select="excludedIdentifier"/>
										</identity>
									</xsl:if>
								</excludeIdentifiers>						
						</xsl:for-each>
						<!--/xsl:if-->
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="resolvedIdentifier">
							<resolvedIdentifiers>
								<assigningAuthority>
									<xsl:value-of select="assigningAuthority"/>
								</assigningAuthority>
								<assigningFacility>
									<xsl:value-of select="assigningFacility"/>
								</assigningFacility>
								<identity>
									<xsl:value-of select="identifier"/>
								</identity>
							</resolvedIdentifiers>
						</xsl:for-each>					
					</xsl:otherwise>
				</xsl:choose>
			</patients>
			<entryPointFilter queryName="queryName">
				<domainEntryPoint>GenericObservation</domainEntryPoint>		
				<xsl:if test="startDate != ''">
					<startDate>
						<xsl:value-of select="startDate"/>
					</startDate>
				</xsl:if>
				<xsl:if test="endDate != ''">
					<endDate>
						<xsl:value-of select="endDate"/>
					</endDate>
				</xsl:if>
				<xsl:if test="jsonPathQuery != ''">
					<jsonPathQuery>
						<jsonPath>
						<xsl:value-of select="jsonPathQuery/jsonPath "/>
						</jsonPath>
					</jsonPathQuery>
				</xsl:if>					
				<xsl:if test="count(./additionalParams/entry) > 0">
					<otherQueryParameters>
						<xsl:for-each select="./additionalParams/entry">
							<additionalParameter name="{@key}" type="text">
								<value>
									<xsl:value-of select="@value"/>
								</value>
							</additionalParameter>
						</xsl:for-each>
					</otherQueryParameters>
				</xsl:if>
			</entryPointFilter>
		</filter:filter>
	</xsl:template>
</xsl:stylesheet>