package gov.va.med.repositories.fpds.validator;

import java.util.Collections;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class ValidationException
    extends
        WebApplicationException
{
    private static final long serialVersionUID = 11660103L;
    private List<? extends ValidationError> violations;

    /**
     * Construct a new instance with an HTTP status code of 500 and an
     * empty list of violations.
     */
    public ValidationException() {
        this(Response.Status.INTERNAL_SERVER_ERROR, Collections.<ValidationError>emptyList());
    }

    /**
     * Construct a new instance with the specified HTTP status code and
     * an empty list of violations.
     *
     * @param status HTTP status code
     */
    public ValidationException(final int status) {
        this(status, Collections.<ValidationError>emptyList());
    }

    /**
     * Construct a new instance with the specified HTTP status code and
     * an empty list of violations.
     *
     * @param status HTTP status code
     * @throws IllegalArgumentException if status is {@code null}
     */
    public ValidationException(final Response.Status status) throws IllegalArgumentException {
        this(status, Collections.<ValidationError>emptyList());
    }

    /**
     * Construct a new instance with the specified HTTP status code and
     * a list of violations.
     *
     * @param status     HTTP status code
     * @param violations list of violations
     * @throws IllegalArgumentException if status or violations is {@code null}
     */
    public ValidationException(final int status, final List<? extends ValidationError> violations)
            throws IllegalArgumentException {
        super(status);
        if (violations == null) {
            throw new IllegalArgumentException("List of violations must not be null");
        }
        this.violations = violations;
    }

    /**
     * Construct a new instance with the specified HTTP status code and
     * a list of violations.
     *
     * @param status     HTTP status code
     * @param violations list of violations
     * @throws IllegalArgumentException if status or violations is {@code null}
     */
    public ValidationException(final Response.Status status, final List<? extends ValidationError> violations)
            throws IllegalArgumentException {
        super(status);
        if (violations == null) {
            throw new IllegalArgumentException("List of violations must not be null");
        }
        this.violations = violations;
    }

    /**
     * Get list of constraint validations.
     *
     * @return list of constraint validations.
     */
    public List<? extends ValidationError> getViolations() {
        return violations;
    }
}
