

package gov.va.med.cds.tools.cleanup.errorq;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;


@ContextConfiguration( locations = { "classpath:gov/va/med/cds/tools/cleanup/errorq/test-errorQCleanUpContext.xml" } )
@RunWith( SpringJUnit4ClassRunner.class )
public class QueueSenderTest
    extends
        AbstractBaseTest
{
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    //injected by Spring
    private QueueSender errorQueueSender;
    


    @javax.annotation.Resource
    public void setErrorQueueSender( QueueSender errorQueueSender )
    {
        this.errorQueueSender = errorQueueSender;
    }
    

    @Test
    @Suite( groups = { "smoketest" } )
    public void testSendMessage( )
        throws Exception
    {
        Resource resource = null;
        String message = null;

        for ( int i = 0; i < 6; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdralgy.er7" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }

//        for ( int i = 0; i < 5; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdradas.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

//        for ( int i = 0; i < 7; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/chdr_hdalgy.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

        for ( int i = 0; i < 5; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrvtls.er7" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }

//        for ( int i = 0; i < 7; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

        for ( int i = 0; i < 8; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref.er7" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }

//        for ( int i = 0; i < 5; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpres.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

//        for ( int i = 0; i < 1; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabBadEncoding.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

        for ( int i = 0; i < 1; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/ping.er7" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }

//        for ( int i = 0; i < 16; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlab.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

//      for ( int i = 0; i < 2; i++ )
//      {
//          resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabSP.er7" );
//          message = StreamUtil.resourceToString( resource );
//          errorQueueSender.sendMessage( message );
//      }
//      for ( int i = 0; i < 1; i++ )
//      {
//          resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabProd.er7" );
//          message = StreamUtil.resourceToString( resource );
//          errorQueueSender.sendMessage( message );
//      }

//        for ( int i = 0; i < 3; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabnofacility.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }
//
//        for ( int i = 0; i < 3; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrlabbadobx.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

        for ( int i = 0; i < 6; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpsim.er7" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
//
//        for ( int i = 0; i < 2; i++ )
//        {
//            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hthca.er7" );
//            message = StreamUtil.resourceToString( resource );
//            errorQueueSender.sendMessage( message );
//        }

        for ( int i = 0; i < 2; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/psimGraphDod.xml" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
        
        for ( int i = 0; i < 2; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/psimGraphVa.xml" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
//        
        for ( int i = 0; i < 2; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/psimGraphVaLocalIdentifier.xml" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
        
        for ( int i = 0; i < 2; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/psimGraphDodLocalIdentifier.xml" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
        
        for ( int i = 0; i < 2; i++ )
        {
            resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/psimGraphDodLocalIdentifierExistsInClinicalDomain.xml" );
            message = StreamUtil.resourceToString( resource );
            errorQueueSender.sendMessage( message );
        }
        
        
    }

}
