

package gov.va.med.cds.tools.cleanup.errorq;


import static org.junit.Assert.assertTrue;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.util.StreamUtil;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfiguration;


@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/tools/cleanup/errorq/test-errorQCleanUpContext.xml" } )
public class ErrorQMessageParserTest
    extends
        AbstractBaseTest
{
    // injected by Spring
    private ErrorQMessageParser messageParser;

    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Resource resource;
    private String hl7Message;
    private String returnValue;


    @Test
    @Suite( groups = { "smoketest" } )
    // please run clean DB before executing the test
    public void testParseMessage( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdralgy.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdradas.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/chdr_hdalgy.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrvtls.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrppar.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpref.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpres.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "<errorSection/>" ) );

        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( returnValue.contains( "Duplicate message" ) );

    }


    @Test( expected = NullPointerException.class )
    @Suite( groups = { "smoketest" } )
    public void testParseMessageWithPsimMessage( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrpsim.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( !returnValue.contains( "<errorSection>" ) );
        
    }


    @Test
    @Suite( groups = { "smoketest" } )
    // please run clean DB before executing the test
    public void testParseMessageWithMissingAssigningFacility( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrAlgyMissingAssigningFacility.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( !returnValue.contains( "<errorSection>" ) );

    }


    @Test
    @Suite( groups = { "smoketest" } )
    // please run clean DB before executing the test
    public void testParseMessageWithMissingStationNumber( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrAlgyMissingStationNumber.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( !returnValue.contains( "<errorSection>" ) );

    }


    @Test( expected = RuntimeException.class )
    @Suite( groups = { "smoketest" } )
    // please run clean DB before executing the test
    public void testParseMessageWithMissingMSH4( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrAlgyMissingMSH4.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( !returnValue.contains( "<errorSection>" ) );

    }


    @Test( expected = RuntimeException.class )
    @Suite( groups = { "smoketest" } )
    // please run clean DB before executing the test
    public void testParseMessageWithInvalidStationNumber( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hdrAlgyInvalidStationNumber.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
        assertTrue( !returnValue.contains( "<errorSection>" ) );

    }


    @Test( expected = RuntimeException.class )
    @Suite( groups = { "smoketest" } )
    public void testParseMessageWithCommitAck( )
        throws Exception
    {
        resource = resourceLoader.getResource( "classpath:gov/va/med/cds/tools/cleanup/errorq/hthca.er7" );
        hl7Message = StreamUtil.resourceToString( resource );
        returnValue = messageParser.parseMessage( hl7Message );
                
    }

    @javax.annotation.Resource
    public void setMessageParser( ErrorQMessageParser messageParser )
    {
        this.messageParser = messageParser;
    }
}
