

package gov.va.med.cds.tools.cleanup.errorq;


import java.util.HashMap;
import java.util.Map;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class ErrorQCleanUpShutDown
{
    private static Log logger = LogFactory.getLog( ErrorQCleanUp.class );
    private static final String NL = System.getProperty( "line.separator" );
    private static final String ADMIN_USER_ENV_PROPERTY_NAME = "USER";
    private static final String ADMIN_PASSWORD_ENV_PROPERTY_NAME = "PASSWORD";


    public static final void usage( )
    {
        logger.error( "The JMX client issues a shutdown or shutdownNow to the ErrorQ-CleanUp process.  " + NL + "Options:" + NL
                        + " -ip - IP Address to ErrorQ-CleanUp." + NL + " -port - Listening port." + NL
                        + " -user - (optional) Specify the username for authentication." + NL
                        + " -password - (optional) Specify the password for authentication." + NL
                        + " -shutdownNow - (optional) true/false (default false)." + NL );

        System.exit( 1 );
    }


    public static void main( String[] args )
    {
        try
        {
            GetArgs opts = new GetArgs( ErrorQCleanUpShutDown.class, args, "ip:port:user:password:shutdownNow", "ip:port:user:password", false );

            String ip = opts.getArg( "ip" );
            String port = opts.getArg( "port" );
            String user = opts.getArg( "user" );
            String password = opts.getArg( "password" );

            // Create an RMI connector client and connect it to the RMI
            // connector server
            JMXServiceURL url = new JMXServiceURL( "service:jmx:rmi:///jndi/rmi://" + ip + ":" + port + "/jmxrmi" );

            Map<String, String> env = new HashMap<String, String>();
            String pkgs = "com.sun.enterprise.admin.jmx.remote.protocol";
            env.put( JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES, pkgs );
            env.put( ADMIN_USER_ENV_PROPERTY_NAME, user );
            env.put( ADMIN_PASSWORD_ENV_PROPERTY_NAME, password );

            JMXConnector jmxc = JMXConnectorFactory.newJMXConnector( url, env );
            jmxc.connect();

            // Get an MBeanServerConnection
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();

            // MBeanServer's domain
            String domain = "errorq-cleanup";

            // Create MigrationManager MBean
            ObjectName stdMBeanName = new ObjectName( domain + ":name=ErrorQCleanUp" );
            mbsc.getObjectInstance( stdMBeanName );

            //check if ErrorQCleanup listenerContainer is running 
            boolean isRunning = ( ( Boolean )mbsc.invoke( stdMBeanName, "isRunning", null, null ) ).booleanValue();
            if ( isRunning )
            {
                logger.info( "Issue Shutdown..." );
                mbsc.invoke( stdMBeanName, "shutdown", null, null );
            }

            //close JMXConnector
            jmxc.close();
        }
        catch ( Exception e )
        {
            logger.error( e.getStackTrace(), e );
        }
    }
}
