

package gov.va.med.cds.work;


import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class WorkListenerTest
{

    @Test
    @Suite( groups = "checkintest" )
    public void testWorkListenerCounts( )
    {
        int jobs = 5;

        CompletingWorkListener wl = new CompletingWorkListener( Thread.currentThread() );

        for ( int i = 0; i < jobs; i++ )
        {
            wl.workAccepted( null );
        }
        assertFalse( wl.allWorkIsComplete() );

        wl.workStarted( null );
        wl.workStarted( null );
        assertFalse( wl.allWorkIsComplete() );

        // test one doesn't say all is done
        wl.workCompleted( null );
        assertFalse( wl.allWorkIsComplete() );

        // complete the rest
        for ( int i = 0; i < jobs - 1; i++ )
        {
            wl.workCompleted( null );
        }
        assertTrue( wl.allWorkIsComplete() );

        // add another one and reject it
        wl.workRejected( null );
        assertFalse( wl.allWorkIsComplete() );
        wl.workCompleted( null );
        assertTrue( wl.allWorkIsComplete() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testWorkListener( )
    {
        int jobs = 5;

        CompletingWorkListener wl = new CompletingWorkListener();

        for ( int i = 0; i < jobs; i++ )
        {
            wl.workAccepted( null );
        }
        assertFalse( wl.allWorkIsComplete() );

        wl.workStarted( null );
        wl.workStarted( null );
        assertFalse( wl.allWorkIsComplete() );

        // test one doesn't say all is done
        wl.workCompleted( null );
        assertFalse( wl.allWorkIsComplete() );

        // complete the rest
        for ( int i = 0; i < jobs - 1; i++ )
        {
            wl.workCompleted( null );
        }
        assertTrue( wl.allWorkIsComplete() );

        // add another one and reject it
        wl.workRejected( null );
        assertFalse( wl.allWorkIsComplete() );
        wl.workCompleted( null );
        assertTrue( wl.allWorkIsComplete() );
    }
}
