

package gov.va.med.cds.util;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class LogMessageUtilTest
{
    private static final String UNIQUE_REQUEST_ID = "E851B78E-0807-1A28-E86C-E1B362624068";


    @Test
    @Suite( groups = "checkintest" )
    public void testBuildMessage( )
    {
        String clinicalDomain = "IntoleranceCondition";
        String appName = "CDS";
        String errorMessage = "Invalid template Id";
        String expectedResult = "#IntoleranceCondition#E851B78E-0807-1A28-E86C-E1B362624068#CDS#Invalid template Id";

        String result = LogMessageUtil.buildMessage( clinicalDomain, UNIQUE_REQUEST_ID, appName, errorMessage );
        assertEquals( result, expectedResult );

        expectedResult = "####";

        result = LogMessageUtil.buildMessage( null, null, null, null );
        assertEquals( result, expectedResult );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        String source = "abcxyz";
        String find = "xyz";
        String strReplacement = "def";
        String expectedResult = "abcdef";

        String result = LogMessageUtil.replace( source, find, strReplacement );
        assertEquals( result, expectedResult );

        int intReplacement = 123;
        expectedResult = "abc123";
        result = LogMessageUtil.replace( source, find, intReplacement );
        assertEquals( result, expectedResult );

        source = "abcxyf";
        int start = 3;
        int end = 5;
        strReplacement = "de";
        expectedResult = "abcdef";
        result = LogMessageUtil.replace( source, start, end, strReplacement );
        assertEquals( result, expectedResult );
        
        source = "abcxyf";
        start = 0;
        end = 5;
        strReplacement = "de";
        expectedResult = "def";
        result = LogMessageUtil.replace( source, start, end, strReplacement );
        assertEquals( result, expectedResult );
    }
}
