

package gov.va.med.cds.uniqueidentifier;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class UniqueIdentifierTest
{
    @Test
    @Suite( groups = "checkintest" )
    public void testRandomGuidNonSecure( )
    {
        UniqueIdentifier identifier = new UniqueIdentifier();
        
        String identifierString = identifier.toString();
        assertNotNull( identifierString );
        assertFalse( "".equals( identifierString ) );

        String identifierValue = identifier.getValue();
        assertNotNull( identifierValue );
        assertFalse( "".equals( identifierValue ) );

        assertEquals( identifierString, identifierValue );
    }
}
