

package gov.va.med.cds.exceptionframework;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(SuiteAwareRunner.class)
public class ExceptionInfoTest
{

    @Test
    @Suite( groups = "checkintest" )
    public void testGetClientMessage( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        String clientMessage = "testMessage";
        exceptionInfoObj.setClientMessage( clientMessage );
        assertEquals( clientMessage, exceptionInfoObj.getClientMessage() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetErrorCode( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        ErrorCodeEnum errorCode = ErrorCodeEnum.ALL_PATIENT_IDS_EXCLUDED;
        exceptionInfoObj.setErrorCode( errorCode );
        assertEquals( ErrorCodeEnum.ALL_PATIENT_IDS_EXCLUDED, exceptionInfoObj.getErrorCode() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetRuntimeException( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        RuntimeException exception = new RuntimeException();
        exceptionInfoObj.setRuntimeException( exception );
        assertEquals( exception, exceptionInfoObj.getRuntimeException() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetException( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        Exception exception = new Exception();
        exceptionInfoObj.setException( exception );
        assertEquals( exception, exceptionInfoObj.getException() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetLoggingSeverity( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        LoggingSeverity loggingSeverity = LoggingSeverity.WARNING;
        exceptionInfoObj.setLoggingSeverity( loggingSeverity );
        assertEquals( loggingSeverity, exceptionInfoObj.getLoggingSeverity() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetExceptionMessage( )
    {
        ExceptionInfo exceptionInfoObj = new ExceptionInfo();
        String exceptionMessage = "WARNING";
        exceptionInfoObj.setExceptionMessage( exceptionMessage );
        assertEquals( exceptionMessage, exceptionInfoObj.getExceptionMessage() );
    }

}
