

package gov.va.med.cds.exception;


import static org.junit.Assert.assertNotNull;

import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.junit.runners.Suite;

import org.junit.Test;
import org.junit.runner.RunWith;

import java.io.IOException;

@RunWith(SuiteAwareRunner.class)
public class SocketClientExceptionTest
{

    @Test( expected = SocketClientException.class )
    @Suite( groups = "checkintest" )
    public void testSocketClientExceptionWithoutThrowable( )
    {
        throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION );
    }


    @Test( expected = SocketClientException.class )
    @Suite( groups = "checkintest" )
    public void testSocketClientExceptionWithThrowable( )
    {
        throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, new IOException() );
    }


    @Test( expected = SocketClientException.class )
    @Suite( groups = "checkintest" )
    public void testSocketClientExceptionWithErrorMessage( )
    {
        throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, new IOException(), "Error Message" );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testSocketClientExceptionWithErrorMessage111( )
    {
        ErrorCodeEnum errorCodeEnum;
        try
        {
            throw new SocketClientException( ErrorCodeEnum.SOCKET_CLIENT_TIMEOUT_EXCEPTION, new IOException(), "Error Message" );
        }
        catch ( SocketClientException e )
        {
            errorCodeEnum = e.getErrorCode();
        }
        assertNotNull( errorCodeEnum.getClientMessage() );
        assertNotNull( errorCodeEnum.getLoggingSeverity() );
    }
}
