/**
 * 
 */
package gov.va.med.cds.clinicaldata.vhim400;

import junit.framework.Assert;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author vhaislegberb
 *
 */
@RunWith(SuiteAwareRunner.class)
public class ConfigurableClinicalDataResponseTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testBuildEmptyClinicalDataDocument( )
    {
        ClinicalDataResponseInterface clinicalDataResponse = new ConfigurableClinicalDataResponse( "patients/patient", "patients/patient/clinicalDocumentEvents", "CdsResponse400" );
        Document document = clinicalDataResponse.buildEmptyClinicalDocument("teqmplatId1", "requestId1");
        
        Element patientElement = clinicalDataResponse.getChildElement( document, "patients/patient" );
        Element clinicalRootElement = clinicalDataResponse.getChildElement( document, "patients/patient/clinicalDocumentEvents");
        
        Assert.assertNotNull( patientElement );
        Assert.assertNotNull( clinicalRootElement );
        
        Assert.assertEquals( "/clinicaldata:ClinicalData/patients/patient", patientElement.getPath() );
        Assert.assertEquals( "/clinicaldata:ClinicalData/patients/patient/clinicalDocumentEvents", clinicalRootElement.getPath() );
        
        Document noPatientDocument = clinicalDataResponse.buildEmptyClinicalDocumentWithoutPatient("teqmplatId1", "requestId1");
        Assert.assertNotNull( noPatientDocument );
        Element nullPatientElement = clinicalDataResponse.getChildElement( noPatientDocument, "patients/patient" );
        Assert.assertNull( nullPatientElement );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetDefaultErrorResponseTemplateId( )
        throws Exception
    {
        ClinicalDataResponseInterface clinicalDataResponse = new ConfigurableClinicalDataResponse( "patients/patient", "patients/patient/clinicalDocumentEvents", "CdsResponse400" );
        Assert.assertEquals( "CdsResponse400", clinicalDataResponse.getErrorResponseTemplateId() );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetNonDefaultErrorResponseTemplateId( )
        throws Exception
    {
        ClinicalDataResponseInterface clinicalDataResponse = new ConfigurableClinicalDataResponse( "patients/patient", "patients/patient/clinicalDocumentEvents", "NonDefaultCdsRead400" );
        Assert.assertEquals( "NonDefaultCdsRead400", clinicalDataResponse.getErrorResponseTemplateId() );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetConfiguredClinicalRootElement( )
        throws Exception
    {
        ClinicalDataResponseInterface clinicalDataResponse = new ConfigurableClinicalDataResponse( "patients/patient", "patients/patient/foobar", "NonDefaultCdsRead400" );
        Document document = clinicalDataResponse.buildEmptyClinicalDocument( "templateId1", "requestId1" );
        Element clinicalRootElement = clinicalDataResponse.getClinicalRoot( document );
        
        Assert.assertNotNull(clinicalRootElement);
        Assert.assertEquals( "/clinicaldata:ClinicalData/patients/patient/foobar", clinicalRootElement.getPath() );
    }
    

    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetFilterParameterElements( )
        throws Exception
    {
        ClinicalDataResponseInterface clinicalDataResponse = new ConfigurableClinicalDataResponse( "patients/patient", "patients/patient/clinicalDocumentEvents", "CdsResponse400" );
        Document document = clinicalDataResponse.buildEmptyClinicalDocument("teqmplatId1", "requestId1");
        
        Element patientElement = clinicalDataResponse.getPatientElement( document );
        Assert.assertNotNull( patientElement );
        Assert.assertEquals( "/clinicaldata:ClinicalData/patients/patient", patientElement.getPath() );
        
        Element requestIdElement = clinicalDataResponse.getRequestId( document ); 
        Assert.assertNotNull( patientElement );
        Assert.assertEquals( "/clinicaldata:ClinicalData/requestId", requestIdElement.getPath() );

        Element templateIdElement = clinicalDataResponse.getTemplateId( document ); 
        Assert.assertNotNull( templateIdElement );
        Assert.assertEquals( "/clinicaldata:ClinicalData/templateId", templateIdElement.getPath() );

        Element newTemplateIdElement = clinicalDataResponse.setTemplateIdText( document, "templateId2");
        Assert.assertNotNull( newTemplateIdElement );
        Assert.assertEquals( "/clinicaldata:ClinicalData/templateId", newTemplateIdElement.getPath() );
        Assert.assertEquals("templateId2", newTemplateIdElement.getText() );
        
    }
    
}
