

package gov.va.med.cds.audit.persistence;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class CdsAuditClobStoreTest
{
    @Test
    @Suite( groups = { "checkintest" } )
    public void testConstructorTest( )
    {
        String requestId = "requestId";
        String hl7Clob = "hl7Clob";
        String facilityId = "facilityId";
        String messageDateTime = "12/12/2008";
        String messageType = "bogusMessageType";
        String templateId = "templateId";
        String clientId = "clientId";

        CdsAuditClobStore clobStore1 = new CdsAuditClobStore();
        clobStore1.setRequestId( requestId );
        clobStore1.setHl7Clob( hl7Clob );
        clobStore1.setFacilityId( facilityId );
        clobStore1.setMessageDateTime( messageDateTime );
        clobStore1.setMessageType( messageType );
        clobStore1.setTemplateId( templateId );
        clobStore1.setClientIdentifier( clientId );

        CdsAuditClobStore clobStore2 = new CdsAuditClobStore( requestId, facilityId, hl7Clob, messageDateTime, messageType, templateId, clientId );
        Assert.assertEquals( clobStore1.getRequestId(), clobStore2.getRequestId() );
        Assert.assertEquals( clobStore1.getFacilityId(), clobStore2.getFacilityId() );
        Assert.assertEquals( clobStore1.getHl7Clob(), clobStore2.getHl7Clob() );
        Assert.assertEquals( clobStore1.getMessageDateTime(), clobStore2.getMessageDateTime() );
        Assert.assertEquals( clobStore1.getMessageType(), clobStore2.getMessageType() );
        Assert.assertEquals( clobStore1.getTemplateId(), clobStore2.getTemplateId() );
        Assert.assertEquals( clobStore1.getClientIdentifier(), clobStore2.getClientIdentifier() );
    }
    
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testHaConstructorTest( )
    {
        String requestId = "requestId";
        String hl7Clob = "hl7Clob";
        String facilityId = "facilityId";
        String messageDateTime = "12/12/2008";
        String messageType = "bogusMessageType";
        String templateId = "templateId";
        String clientId = "clientId";

        HaAuditClobStore clobStore1 = new HaAuditClobStore();
        clobStore1.setRequestId( requestId );
        clobStore1.setHl7Clob( hl7Clob );
        clobStore1.setFacilityId( facilityId );
        clobStore1.setMessageDateTime( messageDateTime );
        clobStore1.setMessageType( messageType );
        clobStore1.setTemplateId( templateId );
        clobStore1.setClientIdentifier( clientId );

        HaAuditClobStore clobStore2 = new HaAuditClobStore( requestId, facilityId, hl7Clob, messageDateTime, messageType, templateId, clientId );
        Assert.assertEquals( clobStore1.getRequestId(), clobStore2.getRequestId() );
        Assert.assertEquals( clobStore1.getFacilityId(), clobStore2.getFacilityId() );
        Assert.assertEquals( clobStore1.getHl7Clob(), clobStore2.getHl7Clob() );
        Assert.assertEquals( clobStore1.getMessageDateTime(), clobStore2.getMessageDateTime() );
        Assert.assertEquals( clobStore1.getMessageType(), clobStore2.getMessageType() );
        Assert.assertEquals( clobStore1.getTemplateId(), clobStore2.getTemplateId() );
        Assert.assertEquals( clobStore1.getClientIdentifier(), clobStore2.getClientIdentifier() );
    }
}
