

package gov.va.med.cds.util;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.XMLWriter;
import org.springframework.core.io.FileSystemResource;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;


/**
 * XmlStringOperations is used to convert Xml to and from string. And to write Xml to file.
 */
public class XmlStringOperations
{
    private static Log logger = LogFactory.getLog( XmlStringOperations.class );
    private static final String APPLICATION_NAME = "CDS";


    /**
     * Reads data from Xml file and converts it into a string.
     * 
     * @param filepath The path to Xml data file
     * 
     * @return filepath the Xml as a string
     */
    public String xmlToString( String filepath )
        throws IOException
    {

        filepath = filepath.replace( '\\', File.separatorChar );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "Loading Xml as string data from file : "
                            + filepath ) );
        }

        FileSystemResource fileSystemResource = new FileSystemResource( filepath );
        String resource = StreamUtil.resourceToString( fileSystemResource );

        if ( logger.isDebugEnabled() )
        {
            logger.debug( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "Xml from file : \n" + resource ) );
        }

        return resource;
    }


    /**
     * Converts a String Xml to Dom Xml and writes to output file
     * 
     * @param xmlAsString string representation of a Xml
     * 
     * @param operation type of CRUDA operation
     * 
     * @return filepath path to output file
     */
    public String xmlStringToXmlFile( String xmlAsString, String operation, String outputFile )
    {
    	FileWriter fileWriter = null;
    	XMLWriter xmlWriter = null;
    	
        try
        {
            Document document = DocumentHelper.parseText( xmlAsString );
            fileWriter = new FileWriter( outputFile );
            xmlWriter = new XMLWriter( fileWriter );
            xmlWriter.write( document );
            xmlWriter.close();
        }
        catch ( DocumentException de )
        {
            logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "Cannot convert  String to Xml : "
                            + de.getStackTrace() ) );
        }
        catch ( IOException ioe )
        {
            logger.error( gov.va.med.cds.util.LogMessageUtil.buildMessage( null, null, APPLICATION_NAME, "Cannot convert  String to Xml : "
                            + ioe.getStackTrace() ) );
        }
    	finally
    	{
    		if ( xmlWriter != null )
    		{
				try
				{
					xmlWriter.close();
				}
				catch ( IOException ioe )
				{
				}
    		}
    		if ( fileWriter != null )
    		{
				try
				{
					fileWriter.close();
				}
				catch ( IOException ioe )
				{
				}
    		}
    	}

        return outputFile;
    }
}
