

package gov.va.med.cds.monitor.util;


import java.io.IOException;
import java.net.MalformedURLException;

import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;


public class MBeanConnectionUtil
{
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";


    public static void enableDisableMBeanConnection( String enableCommand, String server, String port, String principal, String credentials,
                    String beanKeyName )
        throws Exception
    {
        MBeanConnection mbeanConnection = getMBeanConnection( server, port, principal, credentials, beanKeyName );

        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();

        if ( ENABLE.equalsIgnoreCase( enableCommand ) )
        {
            // resets beans to starting values and starts metric collection
            connection.invoke( on, "enableMetrics", null, null );
        }
        else if ( DISABLE.equalsIgnoreCase( enableCommand ) )
        {
            // stops beans from collecting metrics - leaves values in place for
            // reporting
            connection.invoke( on, "disableMetrics", null, null );
        }

        returnMBeanConnection( mbeanConnection );
    }


    /**
     * Backward compatible version of method that is intended for use on a
     * Managed Server - NOT and ADMIN server.
     * Initializes a JSR connection for a managed server
     * 
     * @param server
     * @param port
     * @param principal
     * @param credentials
     * @param beanKeyName
     * @return
     * @throws MalformedObjectNameException
     * @throws MalformedURLException
     * @throws IOException
     */
    public static MBeanConnection getMBeanConnection( String server, String port, String principal, String credentials, String beanKeyName )
        throws MalformedObjectNameException,
            MalformedURLException,
            IOException
    {
        MBeanConnection mbeanConnection = new MBeanConnection();
        mbeanConnection.initConnection( server, port, principal, credentials, beanKeyName );
        return mbeanConnection;
    }


    /**
     * Overloaded method that checks if an Admin or Managed server is requesting
     * a connection - and initializes a connection accordingly
     * 
     * @param managedServer
     * @param server
     * @param port
     * @param principal
     * @param credentials
     * @param beanKeyName
     * @return
     * @throws MalformedObjectNameException
     * @throws MalformedURLException
     * @throws IOException
     */
    public static MBeanConnection getMBeanConnection( boolean managedServer, String server, String port, String principal, String credentials,
                    String beanKeyName )
        throws MalformedObjectNameException,
            MalformedURLException,
            IOException
    {
        MBeanConnection mbeanConnection = new MBeanConnection();
        if ( !managedServer )
        {
            // inits an Admin server jmx remote connection for Admin nodes with deployed applications
            mbeanConnection.initAdminConnection( server, port, principal, credentials, beanKeyName );
        }
        else
        {
            // inits a managed server JSR connection
            mbeanConnection.initConnection( server, port, principal, credentials, beanKeyName );
        }

        return mbeanConnection;
    }


    public static void returnMBeanConnection( MBeanConnection mbeanConnection )
        throws IOException
    {
        mbeanConnection.closeConnection();
    }


    public static Object getMBeanValue( String attribute, boolean managedServer, String server, String port, String principal, String credentials,
                    String beanKeyName )
        throws Exception
    {
        MBeanConnection mbeanConnection = getMBeanConnection( managedServer, server, port, principal, credentials, beanKeyName );
        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();
        Object returnValue = ( Object )connection.getAttribute( on, attribute );
        returnMBeanConnection( mbeanConnection );
        return returnValue;
    }


    public static AttributeList getMBeanValues( String[] attributes, boolean managedServer, String server, String port, String principal,
                    String credentials, String beanKeyName )
        throws Exception
    {
        MBeanConnection mbeanConnection = getMBeanConnection( managedServer, server, port, principal, credentials, beanKeyName );
        MBeanServerConnection connection = mbeanConnection.getConnection();
        ObjectName on = mbeanConnection.getService();
        AttributeList values = connection.getAttributes( on, attributes );
        returnMBeanConnection( mbeanConnection );
        return values;
    }
}
