

package gov.va.med.cds.monitor;


import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import java.lang.reflect.Method;


public class MethodMetricsMonitorInterceptor
    implements
        MethodInterceptor
{
    private static final long serialVersionUID = 113721996432383709L;
    private String methodName;
    private Object metricsBean;


    public Object invoke( MethodInvocation invocation )
        throws Throwable
    {
        long startTime = System.currentTimeMillis();
        Object result = invocation.proceed();
        long elapsedTime = System.currentTimeMillis() - startTime;

        Method method = metricsBean.getClass().getMethod( methodName, new Class[] { long.class } );
        method.invoke( metricsBean, new Object[] { elapsedTime } );
        return result;
    }


    public void setMethodName( String methodName )
    {
        this.methodName = methodName;
    }


    public void setMetricsBean( Object metricsBean )
    {
        this.metricsBean = metricsBean;
    }
}
