

package gov.va.med.cds.exception;


import java.util.Arrays;
import java.util.List;

import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import gov.va.med.cds.exceptionframework.LoggingSeverity;


/**
 *
 * Holds all the error messages used by the exceptions thrown in Cds Core project.
 *
 */
public enum ErrorCodeEnum
{
    // General
    COULD_NOT_CREATE_A_URL( "Could not create a URL. {0}. The reason is {1}. " ),

    // exception handler related
    GUARANTEED_LOGGER_NOT_CONFIGURED_AND_NULL( "Guaranteed logger is not configured and is null." ),
    
    READ_REQUEST_REQUEST_ID_INVALID( "Invalid Request Id {0}.  The Request Id length cannot be > {1}." ),

    // persistence
    HIBERNATE_SESSION_FAILURE( "Unable to get Hibernate Session for the HDR database." ),
    HIBERNATE_READ_FAILURE( "Failed to read from the Hibernate layer. The error is {0}" ),
    HIBERNATE_UPDATE_FAILURE( "Failed to update using the the Hibernate layer. The error is {0}" ),
    HIBERNATE_APPEND_FAILURE( "Failed to append using the the Hibernate layer." ),
    HIBERNATE_DELETE_FAILURE( "Failed to delete using the the Hibernate layer." ),

    HIBERNATE_CREATE_FAILURE( "Failed to create using the the Hibernate layer." ),
    NON_UNIQUE_IDENTITY( "Could not find unique record with this identity:  {0}. The reason is {1}" ),

    CANT_CREATE_IDENTITY( "Failed to create an IdentityInterface object with this Identity:  {0}" ),
    READ_BY_EXAMPLE_FAILURE( "Failed to read data based upon criteria object:  {0}" ),
    UNABLE_TO_RESOLVE_WRITEABLE_PERSISTENCE_MANAGER_FAILURE( "Unable to resolve writeable persistence manager applicable to template meta data." ),

    HDRII_OPERATION_FAILED( "{0} Error:  {1} ..... Working with object:  {2}" ),
    HDRII_CONSTRAINT_VIOLATED( "HDR2 Integrity constraint violated:  {0}" ),
    APPEND_TO_ID_IS_NOT_EQUAL_TO_APPEND_FROM_ID( "Append To ID: {0} is NOT equal to append From ID: {1}." ),
    UPDATE_TO_ID_IS_NOT_EQUAL_TO_UPDATE_FROM_ID( "Update To ID: {0} is NOT equal to update From ID: {1}." ),
    STATUS_HISTORY_NOT_IN_UPDATE_TEMPLATE( "Required StatusHistory was NOT present in update template data." ),
    REACTION_OBSERVATION_NOT_FOUND_TO_UPDATE_IN_HDR( "Required ReactionObservationEvent was NOT present in HDR." ),
    REACTION_ONSET_HISTORY_NOT_IN_UPDATE_TEMPLATE( "Required ReactionOnSetHistory was NOT present in update template data." ),
    PROBLEM_RUNNING_VDM_FILTER( "There was a problem running VDM filter: {0} . Reason is {1}" ),
    SEVERITY_VALUE_HISTORY_NOT_IN_UPDATE_TEMPLATE( "Required SeverityValueHistory was NOT present in update template data." ),
    SEVERITY_OBSERVATION_EVENT_NOT_IN_HDR( "Required SeverityObservationEvent was NOT present in HDR." ),
    ROOT_CAUSE_MSG( "Persistence Failure Message: {1}." ),
    METHOD_NOT_IMPLEMENTED( "{0} getPropertyValue method not implemented." ),
    INVALID_ASSIGNING_FACILITY( "Unable to persist data with an invalid Assigning Facility: {0}.", LoggingSeverity.FATAL ),
    DB_LOGIN_TIMEOUT_NOT_CONFIGURED_AND_NULL( "Database login timeout is not configured and is null." ),

    // Query Work related error codes
    PARAMETER_TRANSFORMER_EXPECTED_ERROR("Parameter transformer for parameter {0} is expected.", LoggingSeverity.ERROR ),

    // persistence manager related error codes
    READ_PERSISTENCE_MGR_NULL_PERSON_IDENTIFIERS_LIST("The persistence manager '{0}' requires that the person identifiers list contains values."),
    READ_PERSISTENCE_MGR_NO_PERSON_WITH_SITE_ID( "There is no person identifier in the list of person identifiers that has a site identifier of {0}."),
    INVALID_OR_UNEXPECTED_QUERY_PARAM( "The query parameter '{0}' is not expected or is invalid." ),
    INVALID_SESSION_INTERCEPTOR( "The sesion interceptor is invalid." ),

    // model assembler exceptions
    MODEL_ASSEMBLER_EXCEPTION_NOT_ALL_RESULTS_ASSEMBLED( "Not all results were assembled. The domain is '{0}' and the association name is '{1}'." ),

    // requests
    REQUEST_TYPE_MISMATCH_OPERATION_VS_INSTANCE( "The API request operation must match the request type defined in the instance XML." ),
    REQUEST_TYPE_MISMATCH_SCHEMA_VS_INSTANCE( "The request type defined by the Template XSD must match the request type defined in the instance XML." ),

    CDS_2X_SERVICE_FAILURE( "Service Call failed on CDS 2x service. The exception is {0} and the reason is {1}" ),
    CDS_SERVICE_EXCEPTION("Service Call failed on CDS service. The reason is {0}."),

    // write requests
    WRITE_REQUEST_XML_NULL( "Write request XML cannot be null or empty." ),
    WRITE_REQUEST_REQUEST_ID_NULL( "Write request request Id cannot be null or empty." ),
    WRITE_REQUEST_TEMPLATE_ID_NULL( "Write request template Id cannot be null or empty." ),
    WRITE_REQUEST_TEMPLATE_ID_INVALID( "Invalid templateId {0}.  The schema is not loaded in cache. The reason is {1}." ),
    WRITE_REQUEST_SIMPLE_INVALID_TEMPLATE_ID( "Invalid template identifier {0}. " ),
    WRITE_REQUEST_VHIM_VERSION_INVALID( "Invalid VHIM version.  Request VHIM version is: '{0}'.  Cached vhim version is: '{1}'." ),
    WRITE_REQUEST_VHIM_VERSION_NULL( "Invalid VHIM version.  Request VHIM version is NULL.  Cached vhim version is: '{1}'." ),
    WRITE_REQUEST_VPID_INVALID( "Invalid VPID for this constraint:  {0}.  Could not write record." ),
    WRITE_REQUEST_VLID_INVALID( "Invalid VLID for this constraint:  {0}.  Could not write record." ),
    WRITE_REQUEST_SURVEY_VENDOR_NAME_INVALID( "Write request survey vendor name is invalid {0}." ),
    WRITE_REQUEST_SURVEY_VENDOR_NUMBER_INVALID( "Write request survey vendor number is invalid {0}." ),
    WRITE_REQUEST_SURVEY_FACILITY_INVALID( "Write request survey facility is invalid {0}." ),
    WRITE_REQUEST_CARE_COORDINATOR_FACILITY_INVALID( "Write request care coordinator facility is invalid {0}." ),
    WRITE_REQUEST_SURVEY_SURVEYID_INVALID( "Write request survey id is invalid {0}." ),
    WRITE_REQUEST_SURVEY_RESPONSES_INVALID( "Incorrect number of question/answer pairs for this survey.  Expected {0}, received {1}." ),

    // read requests
    UNEXPECTED_READ_EXCEPTION( "An unexpected exception occurred while reading data for patient. Assigning Facility is {0}. Patient ID is {1}. Domain entry point is {2}. The message is {3}"),

    READ_REQUEST_OBJECT_NULL( "Read request cannot be null." ),
    READ_REQUEST_TEMPLATE_ID_NULL( "Read request Template Id cannot be null." ),
    READ_REQUEST_FILTER_ID_NULL( "Read request Filter Id cannot be null." ),
    READ_REQUEST_FILTER_XML_NULL( "Read request filter XML cannot be null" ),
    READ_REQUEST_REQUEST_ID_NULL( "Read request Request Id cannot be null." ),
    READ_REQUEST_CLIENT_ID_NULL( "Read request Client Id cannot be null." ),
    READ_REQUEST_FILTER_VHIM_VERSION_INVALID( "Read request filter VHIM version is invalid {0}." ),
    READ_REQUEST_TEMPLATE_ID_INVALID( "Invalid Template Id {0}.  The schema is not loaded in cache." ),
    READ_REQUEST_TEMPLATE_ID_VALIDATION_FAILED( "Template Id {0} failed validation.  {1}" ),
    REQUEST_TYPE_MISMATCH_TEMPLATE_VHIM_VERSION_FILTER_VHIM_VERSION( "The requested read Template VHIM version {0} must match the filter VHIM version {1}" ),
    REQUEST_TYPE_MISMATCH_TEMPLATE_ENTRYPOINT_FILTER_ENTRYPOINT( "The requested read Template entry points {0} must be a subset of the filter entry points {1}" ),
    READ_RESULT_INCORRECTLY_ACCESSED( "The state of the ReadResult does not support this operation." ),
    READ_REQUEST_DATA_SOURCE_FAILURE( "Assigning Facility is {0}. Patient id is {1}. Domain entry point is {2}. Database is {3}. The Error reason is {4}.", LoggingSeverity.WARNING ),
    READ_REQUEST_DATA_SOURCE_ALL_EXCEPTIONS( "This datasource had exceptions for every patient read in this request.", LoggingSeverity.WARNING ),
    READ_REQUEST_ALL_DATA_SOURCES_FAILED( "All datasources failed.  Unable to get data from any applicable datasource.", LoggingSeverity.FATAL ),
    READ_REQUEST_WORK_SCHEDULING_EXCEPTION( "Could not schedule work.", LoggingSeverity.ERROR ),
    READ_REQUEST_WORK_WAIT_INTERRUPTED_EXCEPTION( "InterruptException occurred while waiting for scheduled work to finish.", LoggingSeverity.WARNING ),

    READ_REQUEST_INPUT_PARAMETERS_NULL( "Read request cannot have empty input parameters(s). Empty input parameter(s) are {0}"),
    READ_REQUEST_PARAMETERS_LENGTH_INVALID( "Read request parameters lengths invalid. Parameter(s) are {0}"),
    WRITE_REQUEST_INPUT_PARAMETERS_NULL( "Write request cannot have empty input parameters(s). Empty input parameter(s) are {0}"),
    WRITE_REQUEST_PARAMETERS_LENGTH_INVALID( "Write request parameters lengths invalid. Parameter(s) are {0}"),

    READ_QUERY_STRATEGY_NULL_FAILURE( "The read query strategy for the template {0} and the domain entry point {1} is not defined and is expected to be.", LoggingSeverity.WARNING),
    READ_REQUEST_ALL_DATASOURCES_FAILED( "All datasources failed.  Unable to get data from applicable datasource(s) due to the following reason:\n {0}.", LoggingSeverity.FATAL ),
    ALL_ASSIGNING_FACILITIES_INVALID_IN_FILTER_XML_REQUEST( "All the Assigning Facilities mentioned in the Filter are invalid and they are {0}.", LoggingSeverity.FATAL ),
    INVALID_ASSIGNING_FACILITIES_IN_FILTER_XML_REQUEST( "Invalid Assigning Facilities mentioned in the Filter and they are {0}.", LoggingSeverity.WARNING ),
    CANT_MATCH_TEMPLATE_TO_DELEGATE("Can not match template {0} to available service delegate."),
    READ_REQUEST_DATA_SOURCE_TIMEOUT( "A query timeout occured during the read request. Assigning Facility is {0}. Patient ID is {1}. Domain entry point is {2}. Database is {3}. The Error reason is {4}.", LoggingSeverity.WARNING ),
    READ_REQUEST_PRE_QUERY_FAILURE( "Unable to obtain patient identifiers for patient ID {0}, domain entry point {1}. The Error reason is {2}.", LoggingSeverity.WARNING ),


    // xml parsing
    ATTRIBUTE_IS_REQUIRED( "Attribute {0} is a required attribute." ),
    XSLT_HELPER_TRANSLATION_EXCEPTION( "An error occurred while transforming the data ({0})." ),

    // XML aggregation
    XML_AGGREGATION_ZERO_INPUT_SOURCES( "XML aggregation requires at least one XML input source." ),
    XML_AGGREGATION_VHIM_VERSION_INVALID( "No XML Aggregator found for VHIM version {0}." ),
    XML_AGGREGATION_FAILED( "XML aggregation failed." ),

    // Filter
    MISSING_REFERENCE_XPATH_IN_FILTER( "Missing ReferenceXpath in filter.  Filter id was {0}." ),
    INVALID_XPATH_QUERY( "Invalid xpath query." ),
    INVALID_JSONPATH_QUERY( "Invalid jsonPath query." ),    
    INVALID_OTHER_QUERY_PARAMS( "Invalid content in other query params - {0})."),
    MISSING_XPATH_OR_XPATH_TYPE_IN_QUERYPATH_ELEMENT_OF_FILTER( "Missing xpath and or xpath type in QueryXpath element of filter." ),
    MISSING_XPATH_TYPE_IN_QUERYPATH_ELEMENT_OF_FILTER( "Missing xpath type in QueryXpath element of filter." ),
    VHIM_VERSION_MISMATCH_BETWEEN_READ_CLINICAL_DATA_AND_FILTER( "Read ClinicalData has VHIM version {0} that does not match filter VHIM version {1}." ),
    ERROR_MARSHALLING_FILTER_XML( "Error unmarshalling filter XML. Filter XML was {1}. The reason is {0}. " ),
    NO_ENTRYPOINTS_IN_FILTER( "No entry points specified in filter: {0}." ),
    NO_PATIENT_IDS_REQUESTED( "No patient identifers are requested in the filter.", LoggingSeverity.ERROR ),
    NO_EDIPI_REQUESTED( "No EDIPI requested in the filter." ),
    NO_PATIENT_IDS_RESOLVED( "No patient identifiers could be resolved from the filter.", LoggingSeverity.WARNING  ),
    ALL_PATIENT_IDS_EXCLUDED( "All patient identifiers were excluded by the filter.", LoggingSeverity.WARNING ),
    PATIENT_ID_MISSING_ASSIGNING_AUTHORITY("No assigning authourity value in the patient identifier."),
    EDIPI_PATIENT_ID_MISSING_ASSIGNING_AUTHORITY("No assigning authourity value in the EDIPI."),
    PATIENT_ID_MISSING_ASSIGNING_FACILITY("No assigning facility value in the patient identifier."),
    EDIPI_PATIENT_ID_MISSING_ASSIGNING_FACILITY("No assigning facility value in the EDIPI."),
    PATIENT_ID_MISSING_IDENTITY("No identity value in the patient identifier."),
    EDIPI_PATIENT_ID_MISSING_IDENTITY("No identity value in the EDIPI."),
    CANNOT_PARSE_DATE("Cannot parse the date {0} specified in the filter."),
    CANNOT_PARSE_TIMEOUT("Cannot parse the timeout {0} specified in the filter."),
    PATIENT_ID_CORRELATION_SERVICE_NULL ("Person Identifier Correlation Service is null and not configured."),

    // Filter Patient Resolver
    FILTER_PARSER_DOM_EXCEPTION("Unable to parse the request filter {0}. The reason is {1}."),
    DOC_PARSER_DOM_EXCEPTION("Unable to parse the cache response. The reason is {0}."),
    MULTIPLE_NATIONAL_IDS_IN_FILTER("Multiple national identifiers specified in the filter {0} (only 1 permitted per patient)."),
    ERROR_OBTAINING_CORRESPONDING_IDS("Error while obtaining corresponding IDs for National Id {0}"),
    ERROR_ADDING_RESOLVEDIDENTIFIERS_TO_FILTER("Error adding resolved identifiers to filter."),
    NO_VPID_REQUESTED( "Missing person identity or facility id.  Cannot build database query.  Please resend query with a patient and location.", LoggingSeverity.ERROR ),

    FILTER_RESULT_ASSEMBLER_NOT_CONFIGURED_FOR_TYPE( "A filteredResultAssembler must be configured for the type: {0}. Please check your configuration files. The reason is {1}" ),
    NO_PATIENT_FOUND( "Person Service could not find patient. The error is {0}" ),

    // mapper
    PATHS_TO_RESOURCES_NOT_INITIALIZED( "The paths to resources were null, not initialize." ),
    VHIM_VERSION_NOT_SUPPORTED_IN_MAPPING( "The Vhim Version {0} is NOT supported." ),

    INVALID_ERROR_SECTION_HELPER_FOR_THIS_VERSION_OF_CLINICAL_DATA( "Invalid ErrorSectionHelper for this version of clinical data." ),

    LOADING_OF_RESOURCE_FAILED( "Loading of resource failed. Reason is {0}" ),
    CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT( "Could not find a clinical data root object in the document root . Reason is {0}" ),
    PROBLEM_GETTING_SYMBOL_MAP( "The mapper had a problem getting the symbol map . Reason is {0}" ),
    MARSHALLING_FAILED( "Marshalling {0} produced NO document root. Check the contents of the file. Reason is {1}." ),

    // cdm
    PROBLEM_EXECUTING_CDM_FILTER( "Problem executing CDM Filter." ),

    // Schema helper
    SCHEMA_VALIDATION_FAILED( "Schema validation failed because of {0}" ),
    ERROR_VALIDATIING_XML_AGAINST_COMPILED_SCHEMA( "Error occurred when validating an XML instance against a compiledSchema . Reason is {0}", LoggingSeverity.ERROR ),
    FATAL_ERROR_VALIDATIING_XML_AGAINST_COMPILED_SCHEMA( "Fatal error occurred when validating an XML instance against a compiledSchema . Reason is {0}" ),

    // Schema sequencer
    SCHEMA_XML_NULL( "Schema XML document cannot be null." ),

    // Template Cache
    CANNOT_CREATE_TEMPLATE_CACHE_PERSISTENCE( "Problem occurred creating template cache persistence : {0}." ),
    CANNOT_SAVE_TEMPLATE( "Problem occurred when persisting a template jar: {0}. The reason is {1}." ),
    CANNOT_LOAD_TEMPLATE_CACHE( "Problem occurred when loading template cache: The reason is {0}." ),
    CANNOT_LOAD_SCHEMA_INTO_TEMPLATE_CACHE( "Problem occurred when trying to load a schema into the template cache: {0}. The reason is {1}." ),
    CANNOT_FIND_TEMPLATE_VALIDATOR( "Template schema validator not found in template cache for templateId {0}." ),

    // Template Meta Data Provider
    CANNOT_LOAD_TEMPLATE_METADATA( "Problem loading template meta data for templateId {0}. The reason is {1}." ),

    // SymbolMap Pvoider
    CANNOT_CREATE_TEMPLATE_SCHEMA_SYMBOL_MAP( "Problem creating the symbol map for a template schema: {0}. The reasson is {1}." ),

    // TemplateService
    VTS_SERVICE_FAILED( "The Template Service (VTS) failed: {0} " ),
    CANNOT_MANIPULATE_TEMPLATE_DATA( "The data in the template cannot be manipulated correctly: {0}." ),
    CANNOT_LOAD_TEMPLATE_FROM_VTS( "Problem loading the template with templateId {0} from the VHIM Template Service. The reason is {1}." ),
    NO_TEMPLATE_FOUND_FROM_VTS( "Problem loading the template with templateId {0} from the VHIM Template Service. No template returned." ),

    // Filter Cache
    CANNOT_LOAD_FILTER_SCHEMA_FROM_TFS( "Problem loading the filter with filterId {0} from filter service. The reason is {1}." ),
    CANNOT_LOAD_FILTER_SCHEMA_FROM_PERSISTENCE( "Problem loading the filter with filterId {0} from persistence. The reason is {1}." ),
    CANNOT_LOAD_FILTER_SCHEMA_FROM_FILESYSTEM( "Problem loading the filter with filterId {0} from filesystem. The reason is {1}." ),
    FILTER_MEMORY_CACHE_IS_NOT_PROVIDED( "The filterMemoryCache passed in is null." ),
    CANNOT_SAVE_FILTER_SCHEMA( "Problem occurred when persisting a filter schema : {0}. The reason is {1}." ),
    CANNOT_FIND_FILTER_SCHEMA( "Filter schema not found: {0}." ),
    INVALID_FILTER_SCHEMA( "Invalid filterId {0}. The filter schema is NOT loaded in cache. Reason is {1}." ),
    INVALID_FILTER_INSTANCE("Invalid Filter Instance, filter {0}. Reason is {1}."),
    UNABLE_TO_READ_FILTER_SCHEMA( "Unable to read filter schema with filterId {0}." ),
    CANNOT_FIND_FILTER_VALIDATOR( "Filter schema validator not found in filter cache for filterId {0}." ),
    CANNOT_DELETE_FILTER( "Problem occurred when deleting a filter schema from database: {0}. The reason is {1}." ),
    ERROR_DELETING_FILTER_DOMAIN_TABLES( "Problem deleting filter domain tables : {0}. The reason is {1}." ),

    // entity resolver
    CANNOT_GET_STRING_DATA( "The entity resolver had a problem while getting the string data." ),
    OPERATION_NOT_SUPPORTED( "The method {0} is not supported." ),
    MISSING_SCHEMA_JAR( "Schema jar cannot be null. {0}." ),
    UNABLE_TO_LOAD_SCHEMAS_INTO_CACHE( "Unable to load schemas into the cache for Template name {0}. Reason is {1}." ),
    UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE( "Unable to load schema into the resource. {0}. The reason is {1}." ),
    INVALID_TEMPLATE( "Invalid templateId {0}. The schema is NOT loaded in cache. The reason is {1}." ),

    // IDM
    IDM_NULL_PERSON_IDENTIFIER_EXCEPTION( "Person identifier cannot be null." ),
    IDM_NULL_PERSON_IDENTITY_EXCEPTION( "Person identity cannot be null." ),
    IDM_RESPONSE_PROCESSING_EXCEPTION("An error occurred while processing the IDM service response."),
    IDM_SERVICE_EXCEPTION("An error occured while calling the IDM service. The reason is {0}."),
    IDM_ERROR_RESPONSE("IDM service error for the national id {0}. The IDM error response is {1}."),

    //ExceptionHandler
    TEMPLATE_ID_NULL("The templateId was null"),
    TEMPLATE_HELPER_CONFIGURATION_EXCEPTION("TemplateHelper was not configured for class {0}."),
    MISSING_ERROR_SECTION_HELPER_EXCEPTION("No ErrorSectionHelperInterface was defined in the configuration for templateId {0}."),
    MISSING_CLINICAL_DATA_RESPONSE_EXCEPTION("No ClinicalDataResponseInterface was set while configuring class: {0}."),
    MISSING_PATHWAYS_DATA_RESPONSE_EXCEPTION("No Pathways related DataResponseInterface was set while configuring class: {0}."),
    MISSING_CONFIGURABLE_PATHWAYS_DATA_RESPONSE_MAP_EXCEPTION("No ClinicalDataResponse Map related to Pathways was set while configuring class: {0}."),

    ACCESSOR_ENTRYPOINT_INVALID( "Entrypoint {0} is not valid" ),
    
    // Migrator
    MIGRATOR_MESSAGE_PROCESSOR( "Migrator message processor failure,  Error Code: {0}  Error Message: {1} " ),

    //MEDIATOR
    HL7_SUPPORT_HAPI_PARSE_EXCEPTION( "Error parsing message." ),
    HL7_SUPPORT_HAPI_ENCODE_EXCEPTION( "Error encoding message." ),
    HL7_SUPPORT_HAPI_TERSE_EXCEPTION( "Error tersing message data at {0}." ),
    HL7_SUPPORT_WHAT_CODE_UNSUPPORTED( "The HL7 'what code' field is unsupported for messages that are not of type 'SPQ_Q08'." ),
    WORK_STATE_EXPECTED_DATA_NOT_PRESENT_EXCEPTION( "The expected work state data {0} was not found." ),
    WORK_STATE_DUPLICATE_DATA_EXCEPTION( "The work state data {0} has already been registered." ),
    APPLICATION_ACKNOWLEDGEMENT_NULL( "Application acknowledgement is null" ),
    CLIENT_PROXY_NULL( "Client Proxy is null. Sending App : {0}" ),
    SENDING_ACKNOWLEDGEMENT_ERROR( "Error in sending acknowledement." ),
    HL7_SUPPORT_LEGACY_PARSE_EXCEPTION( "Error parsing message." ),

    // MEDIATOR CLIENT
    MEDIATOR_TCP_SOCKET_CLIENT_ERROR( "An error occurred while interacting with the TCP socket adapter." ),

    // SOCKET CLIENT TIMEOUT
    SOCKET_CLIENT_TIMEOUT_EXCEPTION( "A socket timeout exception occurred." ),

    // SOCKET CLIENT TIMEOUT
    SOCKET_CLIENT_IO_EXCEPTION( "An IO exception has occurred." ),

    // SOCKET CLIENT TIMEOUT
    SOCKET_CLIENT_UNKNOWN_HOST_EXCEPTION( "Unknown host specified." ),

    //MOM
    MDB_ON_MESSAGE_JMS_EXCEPTION( "Error processing message in MDBs onMessage: {0}" ),

    //MLLP
    MLLP_ILLEGAL_ENCODING_EXCEPTION( "MLLP illegal encoding." ),

    // SOCKET ADAPTER MISSING VALUE
    SOCKET_ADAPTER_MISSING_VALUE_EXCEPTION( "Missing value for {0}." ),

    // SOCKET ADAPTER ACCESS DENIED
    SOCKET_ADAPTER_ACCESS_DENIED_EXCEPTION( "Access denied as {0} is not a permitted value for {1}." ),
    SOCKET_ADAPTER_ACCESS_DENIED_EXCEPTION_COMBINATION( "Access denied for combination of {0} and {1} for {2} and {3}." ),
    
    SOCKET_ADAPTER_ACCESS_UNEXPECTED_EXCEPTION( "An unexpected error occurred during access validation." ),
    
    // SOCKET ADAPTER PROCCESSING
    DISPATCH_EXCEPTION( "Error dispatching message for proccessing." ),
    DATABASE_ACCESS_EXCEPTION( "Error connecting to Database." ),

    //Used in tests only
    READ_REQUEST_UNKNOWN_FILTER("Unknown Filter: {0}.", LoggingSeverity.WARNING),

    //XQuery Strategy
    XQUERY_EXPRESSION_EXCEPTION("XQuery execution failed for: domainEntryPoint={0}, elementsToSort={1}, sortKey={2}.", LoggingSeverity.WARNING),

    //CipherUtilities / Encryption
    ENCRYPTION_MISSING_KEYSTORE_PASSWORD_EXCEPTION( "Missing KeyStore password in System Parameters (required for encryption and decryption)." ),
    ENCRYPTION_MISSING_KEYSTORE_FILEPATH_EXCEPTION( "Missing KeyStore file path (required for encryption and decryption)." ),
    ENCRYPTION_EXCEPTION( "Encryption exception." ),

    // AUDIT_CLOB_STR error
    CDS_AUDIT_CLOB_STORE_ERROR("Error in auditing VHIM write request."),
    CDS_AUDIT_LOG_ERROR("Error in auditing VHIM read request."),

    // VHIM Response XML
    WRITE_RESPONSE_NULL("The VHIM response XML from CDS was null"),
    WRITE_RESPONSE_MALFORMED("The VHIM response XML from CDS was malformed"),
    
    //MarshallUnmarshall
    UNMARSHALL_ELEMENT("Unable to unmarshall element into object for domainEntryPoint: {0}"),
    MARSHAll_ELEMENT("Unable to marshal object to Xml for domainEntryPoint: {0}"),

    //ARS
    ARS_READ_REQUEST_REPORT_ID_NULL( "Read request Report Id cannot be null." ),

    // Census write
    WRITE_REQUEST_CENSUS_SEGMENT_DUPLICATE( " Write request census segment is duplicate. Report Start Date: {0}; Segment DateTime: {1}; Current Segment: {2}" ),
    WRITE_REQUEST_CENSUS_STATUS_COMPLETE( " Total number of segments had already been received earlier and the status is COMPLETE, cannot persist this request. Report Start Date: {0}; Segment DateTime: {1}" ),
    WRITE_REQUEST_CENSUS_INVALID_START_DATE(" Missing or wrong census report start or end dates specified. Census start date: {0}; Census End date: {1}; Message Id: {2}; Vendor Id: {3}"),
    WRITE_REQUEST_CENSUS_SEGMENT_FAILED(" Previous segment was FAILED, cannot persist. Report Start Date: {0}; Segment DateTime: {1}; Current Segment: {2}" ),
    WRITE_REQUEST_CENSUS_NO_OF_SEGS_RECEPTION_TIME_EXPIRED(" Census Report segments missing or too many sent or not sent in a timely manner. Census start date: {0}; Census End date: {1}; Message Id: {2}; Vendor Id: {3}"),
    WRITE_REQUEST_CENSUS_ACK_ALREADY_SENT(" Already sent the Census Acknowledgement"),

    // Census read
    CENSUS_REPORT_INVALID_START_DATE("Census report start date: {0} is invalid"),
    CENSUS_REPORT_INVALID_END_DATE("Census report end date: {0} is invalid"),
    CENSUS_REPORT_INVALID_TIME_PERIOD("Census report end date:  {0} is not the following Saturday of start date: {1}"),
    CENSUS_REPORT_RECORD_COUNT_INVALID("Census report record count is {0}, it should be 1}"),
    // ******************************************************************
    // ******************************************************************
    // ******************************************************************
    // ******************************************************************
    // ******************************************************************
    
    // Census transform acknowledgement
    ERROR_IN_PERSISTENCE_LAYER( "Error in persistence layer" ),
    CENSUS_ACKNOWLEDGEMENT_RESPONSE_IS_NULL("CensusAcknowledgementResponse is null"),
    CENSUS_COMPLETE_WEEK_IS_NULL("CensusCompleteWeek is null"),
    NULL_MED_APP_CONTEXT("Mediator App Context is NULL"),
    UNABLE_TO_LOAD_MED_APP_CONTEXT("Unable to load mediator Application Context"),
    UNABLE_TO_LOAD_FROM_APP_CONTEXT("Unable to load bean into a Quartz job context");


    private String clientMessage = null;
    private List<ExceptionLoggerInterface> loggers = null;
    private LoggingSeverity loggingSeverity = null;
    private static ExceptionLoggerInterface[] allLoggers = new ExceptionLoggerInterface[] { };


    ErrorCodeEnum( String clientMessage )
    {
        this( clientMessage, LoggingSeverity.FATAL, ( ExceptionLoggerInterface[] )null );
    }


    /**
     * Use this constructor to change the default logging severity of exceptions.
     */
    ErrorCodeEnum( String clientMessage, LoggingSeverity loggingSeverity )
    {
        this( clientMessage, loggingSeverity, ( ExceptionLoggerInterface[] )null );
    }


    /**
     * Use this constructor to change the default logging severity of exceptions and the default list of loggers.
     */
    ErrorCodeEnum( String clientMessage, LoggingSeverity loggingSeverity, ExceptionLoggerInterface... loggers )
    {
        this.clientMessage = clientMessage;
        this.loggingSeverity = loggingSeverity;
        setLoggers( loggers );
    }


    /**
     * sets the loggers.
     *
     * @param exceptionLoggers - Default and eels loggers.
     */
    private void setLoggers( ExceptionLoggerInterface[] exceptionLoggers )
    {
        if ( exceptionLoggers != null )
        {
            loggers = Arrays.asList( exceptionLoggers );
        }
        else
        {
            loggers = null;
        }
    }


    /**
     * Gets the message associated with the error code enum.
     *
     * @return The error message associated with the error code enum.
     */
    public String getClientMessage( )
    {
        return clientMessage;
    }


    /**
     * Gets the logging severity.
     *
     * @return The logging severity associated with the error message.
     */
    public LoggingSeverity getLoggingSeverity( )
    {
        return loggingSeverity;
    }



    /**
     * Gets the available loggers.
     *
     * @return List of loggers - default, eels.
     */
    public List<ExceptionLoggerInterface> getLoggers( )
    {
        if ( loggers == null )
        {
            loggers = Arrays.asList( allLoggers );
        }
        return loggers;
    }
}
