

package gov.va.med.cds.exception;


import gov.va.med.cds.exception.AbstractCdsBaseException;
import gov.va.med.cds.exception.ErrorCodeEnum;


/**
 * Handles exceptions thrown by AuditClobStore.
 * 
 */
public class CensusTransformAckException
    extends
        AbstractCdsBaseException
{

    private static final long serialVersionUID = 4783429399489832692L;


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public CensusTransformAckException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public CensusTransformAckException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for persistence modifications
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public CensusTransformAckException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }
}
