

package gov.va.med.cds.exception;


/**
 *
 * Base exception class of all the CDS core project exceptions.
 *
 */
public abstract class AbstractCdsBaseException
    extends
        RuntimeException
{

    private static final long serialVersionUID = -5245555022031244412L;

    private ErrorCodeEnum errorCode = null;

    private String[] customMsgValues = null;


    public AbstractCdsBaseException( ErrorCodeEnum errorCode )
    {
        this( errorCode, null, ( String[] )null );
    }


    public AbstractCdsBaseException( ErrorCodeEnum errorCode, String... customMsgValues )
    {
        this( errorCode, null, customMsgValues );
    }


    public AbstractCdsBaseException( ErrorCodeEnum errorCode, Throwable cause )
    {
        this( errorCode, cause, ( String[] )null );
    }


    public AbstractCdsBaseException( ErrorCodeEnum errorCode, Throwable cause, String... customMsgValues )
    {
        super( errorCode.toString(), cause );

        setErrorCode( errorCode );
        setCustomMsgValues( customMsgValues );

    }


    /**
     * Gets the errorcode that has the error message.
     */

    public ErrorCodeEnum getErrorCode( )
    {
        return errorCode;
    }


    /**
     * Sets the errorcode that has the error message.
     */
    private void setErrorCode( ErrorCodeEnum errorCodeName )
    {
        this.errorCode = errorCodeName;
    }


    /**
     * Gets the runtime data values to be embedded in the error message.
     */
    public String[] getCustomMsgValues( )
    {
        return customMsgValues;
    }


    /**
     * Sets the runtime data values to be embedded in the error message.
     */
    public void setCustomMsgValues( String[] customMsgValues )
    {

        this.customMsgValues = customMsgValues;

    }
}
