

package gov.va.med.cds.clinicaldata.vhim400;


import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.springframework.util.StringUtils;


public class ConfigurablePathwaysDataResponse
    extends
        ConfigurableClinicalDataResponse
    implements
        PathwaysDataResponseInterface

{
    private String schemaNamespacePrefix;
    private String schemaNamespaceUri;
    private String schemaLocalName;
    private static String SCHEMA_NAMESPACE_PREFIX = "pathwaysdata";
    private static String SCHEMA_NAMESPACE_URI = "Pathwaysdata";
    private static String SCHEMA_LOCAL_NAME = "PathwaysData";


    public ConfigurablePathwaysDataResponse( String patientElementPath, String clinicalRootPath, String errorResponseTemplateId )
    {
        super( patientElementPath, clinicalRootPath, errorResponseTemplateId );
    }


    public ConfigurablePathwaysDataResponse( String patientElementPath, String clinicalRootPath, String errorResponseTemplateId,
                    String schemaNamespacePrefix, String schemaNamespaceUri, String schemaLocalName )
    {
        super( patientElementPath, clinicalRootPath, errorResponseTemplateId );
        this.schemaNamespacePrefix = schemaNamespacePrefix;
        this.schemaNamespaceUri = schemaNamespaceUri;
        this.schemaLocalName = schemaLocalName;
    }

    public Document buildEmptyPathwaysDocumentWithPatient( String templateId, String requestId )
    {
        return buildPathwaysDocument( templateId, requestId, true, null, null );
    }

    public Document buildEmptyPathwaysDocumentWithPatient( String templateId, String requestId, String clName, String clReqTime )
    {
        return buildPathwaysDocument( templateId, requestId, true, clName, clReqTime );
    }

    public Document buildEmptyPathwaysDocumentWithoutPatient( String templateId, String requestId, String clName, String clReqTime )
    {
        return buildPathwaysDocument( templateId, requestId, false, clName, clReqTime );
    }
    
    public Document buildEmptyPathwaysDocumentWithoutPatient( String templateId, String requestId )
    {
        return buildPathwaysDocument( templateId, requestId, false, null, null );
    }


    private Document buildPathwaysDocument( String templateId, String requestId, boolean addPatient, String clientName, String clientReqTime )
    {
        if ( !StringUtils.hasText( schemaNamespacePrefix ) )
        {
            schemaNamespacePrefix = SCHEMA_NAMESPACE_PREFIX;
        }
        if ( !StringUtils.hasText( schemaNamespaceUri ) )
        {
            schemaNamespaceUri = SCHEMA_NAMESPACE_URI;
        }
        if ( !StringUtils.hasText( schemaLocalName ) )
        {
            schemaLocalName = SCHEMA_LOCAL_NAME;
        }

        Namespace pathwaysDataNamespace = DocumentHelper.createNamespace( schemaNamespacePrefix, schemaNamespaceUri );
        Element pathwaysDataElement = DocumentHelper.createElement( DocumentHelper.createQName( schemaLocalName, pathwaysDataNamespace ) );

        if ( templateId != null )
        {

            getChildElement( pathwaysDataElement, templateIdElementName, true ).addText( templateId );
        }

        if ( requestId != null )
        {
            getChildElement( pathwaysDataElement, requestIdElementName, true ).addText( requestId );
        }

        if ( clientName != null )
        {
            getChildElement( pathwaysDataElement, CLIENT_NAME_ELEMENT_NAME, true ).addText( clientName );
        }

        if ( clientReqTime != null )
        {
            getChildElement( pathwaysDataElement, CLIENT_REQUEST_INITIATION_TIME_ELEMENT_NAME, true ).addText( clientReqTime );
        }

        if ( addPatient )
        {
            getChildElement( pathwaysDataElement, this.patientElementPath, true );
        }

        return DocumentHelper.createDocument( pathwaysDataElement );
    }

}
