/**
 * 
 */


package gov.va.med.cds.clinicaldata;



import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

import javax.sql.rowset.serial.SerialBlob;

import org.hibernate.engine.jdbc.NonContextualLobCreator;


/**
 * @author vhaislecclej
 * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public class TfsTemplateMetaData
    implements
        TfsTemplateMetaDataInterface
{
    private Date dateAdded;
    private Date dateDeprecated;
    private Date dateActivated;
    private Date dateDeactivated;
    private Date dateUpdated;
    private String status;
    protected String[] vhimVersions;
    protected Set<DomainEntryPoint> domainEntryPoints;
    private byte[] templateJar;

    
    public Date getDateAdded() 
    {
        return dateAdded;
    }

    public void setDateAdded(Date dateAdded) 
    {
        this.dateAdded = dateAdded;
    }

    
    public Date getDateDeprecated() 
    {
        return dateDeprecated;
    }

    public void setDateDeprecated(Date dateDeprecated) 
    {
        this.dateDeprecated = dateDeprecated;
    }

    
    public Date getDateActivated() 
    {
        return dateActivated;
    }

    public void setDateActivated(Date dateActivated) 
    {
        this.dateActivated = dateActivated;
    }

    
    public Date getDateDeactivated() 
    {
        return dateDeactivated;
    }

    public void setDateDeactivated(Date dateDeactivated) 
    {
        this.dateDeactivated = dateDeactivated;
    }

    
    public Date getDateUpdated() 
    {
        return dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) 
    {
        this.dateUpdated = dateUpdated;
    }

    
    public String getStatus() 
    {
        return status;
    }

    public void setStatus(String status) 
    {
        this.status = status;
    }

    
    public byte[] getTemplateJar() 
    {
        return templateJar;
    }

    public void setTemplateJar(byte[] templateJar) 
    {
        this.templateJar = templateJar;
    }

    @SuppressWarnings( "unused" )
    // used by hibernate
    private void setBlob( Blob jar )
    {
        this.templateJar = toByteArray( jar );
    }


    @SuppressWarnings( "unused" )
    // used by hibernate
    private Blob getBlob( )
    {
        //return templateJar == null ? null : Hibernate.createBlob( this.templateJar );
    	return templateJar == null ? null : createBlob(this.templateJar);	
    }
    
    /**
     * Method duplicates original functionality of the deprecated Hibernate.createBlob - this method is the exact functionality
     * for CDS use it seems sufficient as we do not have a context to create a session to get a LobCreator.
     * 
     * @param bytes
     * @return
     */
    private java.sql.Blob createBlob(byte[] bytes) {
		Blob blob = null;
    	blob = NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(bytes));
    	return blob;
	}
    private java.sql.Blob createBlob2(byte[] bytes) {
		Blob blob = null;
    	try{
			blob = new SerialBlob(bytes);
		}catch(Exception e){
		 //will return null;
		}
    	return blob;
	}

	private byte[] toByteArray( Blob fromJar )
    {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try
        {
            return toByteArrayImpl( fromJar, baos );
        }
        catch ( Exception e )
        {
        }
        return null;
    }


    private byte[] toByteArrayImpl( Blob fromJar, ByteArrayOutputStream baos )
        throws SQLException,
            IOException
    {
        byte buf[] = new byte[4000];
        int dataSize;
        InputStream is = fromJar.getBinaryStream();

        try
        {
            while ( ( dataSize = is.read( buf ) ) != -1 )
            {
                baos.write( buf, 0, dataSize );
            }
        }
        finally
        {
            if ( is != null )
            {
                is.close();
            }
        }
        return baos.toByteArray();
    }    


    
    
    public void setVhimVersions( Set<String> aVhimVersions )
    {
        vhimVersions = (String[]) aVhimVersions.toArray();
    }
    
    
    /**
     * @return the vhimVersion
     */
    public String[] getVhimVersions( )
    {
        return vhimVersions;
    }


    /**
     * @param aVhimVersions the set of vhimVersions to set
     */
    public void setVhimVersions( String[] aVhimVersions )
    {
        vhimVersions = aVhimVersions;
    }

    
    /**
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public Operation operation;


    /**
     * @return the operation
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public Operation getOperation( )
    {
        // begin-user-code
        return operation;
        // end-user-code
    }

    public String getOperationAsString( )
    {
        // begin-user-code
        return operation.name();
        // end-user-code
    }


    /**
     * @param theOperation the operation to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setOperation( Operation theOperation )
    {
        // begin-user-code
        operation = theOperation;
        // end-user-code
    }
    public void setOperationAsString( String theOperation )
    {
        operation = Operation.valueOf( theOperation );
    }
    

    /**
     * @return the domainEntryPoints
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public Set<DomainEntryPoint> getDomainEntryPoints( )
    {
        // begin-user-code
        return domainEntryPoints;
        // end-user-code
    }


    /**
     * @param theDomainEntryPoints the domainEntryPoints to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setDomainEntryPoints( Set<DomainEntryPoint> theDomainEntryPoints )
    {
        // begin-user-code
        domainEntryPoints = theDomainEntryPoints;
        // end-user-code
    }
    

    /**
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String cdsVdm;


    /**
     * @return the vhimVersion
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getWriteCdsVdm( )
    {
        // begin-user-code
        return cdsVdm;
        // end-user-code
    }


    /**
     * @param aCdsVdm the vhimVersion to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setWriteCdsVdm( String aCdsVdm )
    {
        // begin-user-code
        cdsVdm = aCdsVdm;
        // end-user-code
    }


    /**
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String templateId;


    /**
     * @return the templateId
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getTemplateId( )
    {
        // begin-user-code
        return templateId;
        // end-user-code
    }


    /**
     * @param theTemplateId the templateId to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setTemplateId( String theTemplateId )
    {
        // begin-user-code
        templateId = theTemplateId;
        // end-user-code
    }

    /**
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String templateName;


    /**
     * @return the templateName
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getTemplateName( )
    {
        // begin-user-code
        return templateName;
        // end-user-code
    }


    /**
     * @param theTemplateName the templateName to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setTemplateName( String theTemplateName )
    {
        // begin-user-code
        templateName = theTemplateName;
        // end-user-code
    }

    /**
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String templateDescription;


    /**
     * @return the templateDescription
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getTemplateDescription( )
    {
        // begin-user-code
        return templateDescription;
        // end-user-code
    }


    /**
     * @param theTemplateDescription the templateDescription to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setTemplateDescription( String theTemplateDescription )
    {
        // begin-user-code
        templateDescription = theTemplateDescription;
        // end-user-code
    }

    
    
    public boolean testOnly;
    
    
    public boolean getTestOnly( )
    {
        return testOnly;
    }
    
    
    public void setTestOnly( boolean aTestOnly )
    {
        this.testOnly = aTestOnly;
    }    
    
    public void setTestOnly( String aTrueOrFalse )
    {
        this.testOnly = Boolean.parseBoolean( aTrueOrFalse );
    }
}
