

package gov.va.med.cds.clinicaldata;


import java.util.HashSet;
import java.util.Set;


public class TemplateMetaData
    extends
        TfsTemplateMetaData
    implements
        TemplateMetaDataInterface
{
    private Set<VhimVersionWrapper> vhimVersionWrappers = null;
    private Set<DomainEntryPointWrapper> domainEntryPointWrappers = null;

    /**
     * The HashSet of valid Read CDS VDM's corresponding to Vhim Versions
     */
    private HashSet<String> readCdsVdms;


    /**
     * @return the HashSet of valid Read CDS VDM's
     */
    public HashSet<String> getReadCdsVdms( )
    {
        if ( readCdsVdms == null )
        {
            readCdsVdms = new HashSet<String>();
        }

        return readCdsVdms;
    }


    /**
     * @param aCdsVdms the HashSet of valid Read CDS VDM's to set
     */
    public void setReadCdsVdms( HashSet<String> aCdsVdms )
    {
        readCdsVdms = aCdsVdms;
    }


    //adding hibernate and template service specific methods
    public Set<VhimVersionWrapper> getVhimVersionWrappers( )
    {
        if ( vhimVersionWrappers == null && vhimVersions != null )
        {
            vhimVersionWrappers = new HashSet<VhimVersionWrapper>( vhimVersions.length );
            VhimVersionWrapper vvw;
            for ( String vhimVersion : vhimVersions )
            {
                vvw = new VhimVersionWrapper();
                vvw.setVersion( vhimVersion );
                vhimVersionWrappers.add( vvw );
            }
        }
        return vhimVersionWrappers;
    }


    public void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersionWrappers )
    {
        vhimVersionWrappers = aVhimVersionWrappers;

        if ( vhimVersions == null && aVhimVersionWrappers != null )
        {
            vhimVersions = new String[aVhimVersionWrappers.size()];
            int index = 0;
            for ( VhimVersionWrapper vhimVersionWrapper : aVhimVersionWrappers )
            {
                vhimVersions[index++ ] = vhimVersionWrapper.getVersion();
            }
        }
    }


    public Set<DomainEntryPointWrapper> getDomainEntryPointWrappers( )
    {
        if ( domainEntryPointWrappers == null && domainEntryPoints != null )
        {
            domainEntryPointWrappers = new HashSet<DomainEntryPointWrapper>( domainEntryPoints.size() );
            DomainEntryPointWrapper depw;
            for ( DomainEntryPoint domainEntryPoint : domainEntryPoints )
            {
                depw = new DomainEntryPointWrapper();
                depw.setName( domainEntryPoint.getName() );
                depw.setDomain( domainEntryPoint.getDomain() );
                domainEntryPointWrappers.add( depw );
            }
        }
        return domainEntryPointWrappers;
    }


    public void setDomainEntryPointWrappers( Set<DomainEntryPointWrapper> aDomainEntryPointWrappers )
    {
        domainEntryPointWrappers = aDomainEntryPointWrappers;

        if ( domainEntryPoints == null && aDomainEntryPointWrappers != null )
        {
            domainEntryPoints = new HashSet<DomainEntryPoint>( aDomainEntryPointWrappers.size() );
            DomainEntryPoint dep;
            for ( DomainEntryPointWrapper domainEntryPoint : aDomainEntryPointWrappers )
            {
                dep = DomainEntryPoint.valueOf( domainEntryPoint.getName() );
                domainEntryPoints.add( dep );
            }
        }
    }
}
