

package gov.va.med.cds.clinicaldata;

import java.util.HashSet;
import java.util.Set;



/**
 * This class implements the methods required for handling the Filter Cache Metadata. The Metadata consists
 * of: 
 * <li>FilterId
 * <li>Filter Schema (XSD)
 * <li>Validator
 * <li>VHIM Version
 * <li>Domain Entry Points
 * <br>
 * 
 */
public class FilterMetaData
    extends
        TfsFilterMetaData
    implements
        FilterMetaDataInterface
{
    private Set<VhimVersionWrapper> vhimVersionWrappers = null;
    
    

    //adding hibernate and template service specific methods
    public Set<VhimVersionWrapper> getVhimVersionWrappers( )
    {
        if ( vhimVersionWrappers == null && vhimVersions != null )
        {
            vhimVersionWrappers = new HashSet<VhimVersionWrapper>( vhimVersions.size() );
            VhimVersionWrapper vvw;
            for ( String vhimVersion : vhimVersions )
            {
                vvw = new VhimVersionWrapper();
                vvw.setVersion( vhimVersion );
                vhimVersionWrappers.add( vvw );
            }
        }
        return vhimVersionWrappers;
    }

    public void setVhimVersionWrappers( Set<VhimVersionWrapper> aVhimVersionWrappers )
    {
        vhimVersionWrappers = aVhimVersionWrappers;
        
        if ( vhimVersions == null && aVhimVersionWrappers != null )
        {
            vhimVersions = new HashSet<String>( aVhimVersionWrappers.size() );
            for ( VhimVersionWrapper vhimVersionWrapper : aVhimVersionWrappers )
            {
                vhimVersions.add( vhimVersionWrapper.getVersion() );
            }
        }
    }
}
