package gov.va.med.cds.clinicaldata;



public class EntryFilter
{
    private DomainEntryPoint domainEntryPoint;
    private String xpath;
    private DomainEntryPointWrapper domainEntryPointWrapper;
    
    
    public void setXpath( String aXpath )
    {
        this.xpath = aXpath;
    }
    
    public String getXpath( )
    {
        return xpath;
    }
    
    public void setDomainEntryPoint(DomainEntryPoint aDomainEntryPoint) 
    {
        this.domainEntryPoint = aDomainEntryPoint;
    }
    
    public DomainEntryPoint getDomainEntryPoint() 
    {
        return domainEntryPoint;
    }
    
    public void setDomainEntryPointWrapper( DomainEntryPointWrapper aDomainEntryPointWrapper ) 
    {
        domainEntryPointWrapper = aDomainEntryPointWrapper;
        if ( domainEntryPoint == null && aDomainEntryPointWrapper != null && aDomainEntryPointWrapper.getName() != null )
        {
                domainEntryPoint = DomainEntryPoint.valueOf( aDomainEntryPointWrapper.getName() );
        }
    }
    
    public DomainEntryPointWrapper getDomainEntryPointWrapper() 
    {
        if ( domainEntryPointWrapper == null && domainEntryPoint != null )
        {
            domainEntryPointWrapper = new DomainEntryPointWrapper();
            domainEntryPointWrapper.setName( domainEntryPoint.getName() );
            domainEntryPointWrapper.setDomain( domainEntryPoint.getDomain() );
        }
        return domainEntryPointWrapper;
    }
    
    @Override
    public int hashCode( )
    {
        int hash = 0;
        if ( xpath != null )
        {
            hash += xpath.hashCode();
        }
        
        if ( getDomainEntryPointWrapper() != null)
        {
            hash += domainEntryPointWrapper.hashCode();
        }
        return hash;
    }
    
    @Override
    public boolean equals( Object obj )
    {
        if ( obj instanceof EntryFilter )
        {
            EntryFilter value = (EntryFilter)obj;
            String xpath = value.getXpath();
            
            if ( ( (xpath == null && this.xpath == null) || value.getXpath().equals( xpath )) && value.getDomainEntryPointWrapper().equals( getDomainEntryPointWrapper() ) )
            {
                return true;
            }
        }
        return false;
    }

}
