

package gov.va.med.cds.audit.persistence.hibernate;


import java.util.List;

import org.springframework.orm.hibernate4.HibernateOperations;

import gov.va.med.cds.audit.TemplateIdWrapper;
import gov.va.med.cds.audit.persistence.CdsAuditClobStore;
import gov.va.med.cds.audit.persistence.CdsAuditClobStoreInterface;
import gov.va.med.cds.audit.persistence.HaAuditClobStore;
import gov.va.med.cds.audit.persistence.PathwaysAuditClobStore;

public class PersistAuditStore
    implements
        CdsAuditClobStoreInterface
{

    private HibernateOperations hibernateOperations;

    public void persistCdsAuditClob( CdsAuditClobStore cdsAuditClob )
    {
        persistTemplateIdWrapper( cdsAuditClob );
        hibernateOperations.save( cdsAuditClob );
      
    }

    public void persistHaAuditClob( HaAuditClobStore haAuditClob )
    {
        persistTemplateIdWrapper( haAuditClob );
        hibernateOperations.save( haAuditClob );
    }

    public void persistPathwaysAuditClob( PathwaysAuditClobStore pathwaysAuditClobStore )
    {
        persistTemplateIdWrapper( pathwaysAuditClobStore );
        hibernateOperations.save( pathwaysAuditClobStore );
    }
    
    private void persistTemplateIdWrapper(PathwaysAuditClobStore pathwaysAuditClobStore) {
    	 List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( pathwaysAuditClobStore.getTemplateIdWrapper() );
         if ( hibernateTemplateIds.size() < 1 )
         {
             hibernateOperations.save( pathwaysAuditClobStore.getTemplateIdWrapper() );
         }
         else
         {
        	 pathwaysAuditClobStore.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
         }
		
	}

	@SuppressWarnings( "unchecked" )
    private void persistTemplateIdWrapper( CdsAuditClobStore cdsAuditClob )
    {
        List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( cdsAuditClob.getTemplateIdWrapper() );
        if ( hibernateTemplateIds.size() < 1 )
        {
            hibernateOperations.save( cdsAuditClob.getTemplateIdWrapper() );
        }
        else
        {
            cdsAuditClob.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
        }
    }


    @SuppressWarnings( "unchecked" )
    private void persistTemplateIdWrapper( HaAuditClobStore haAuditClob )
    {
        List<TemplateIdWrapper> hibernateTemplateIds = hibernateOperations.findByExample( haAuditClob.getTemplateIdWrapper() );
        if ( hibernateTemplateIds.size() < 1 )
        {
            hibernateOperations.save( haAuditClob.getTemplateIdWrapper() );
        }
        else
        {
            haAuditClob.setTemplateIdWrapper( hibernateTemplateIds.get( 0 ) );
        }
    }


    public void setHibernateTemplate( HibernateOperations hibernateOperations )
    {
        this.hibernateOperations = hibernateOperations;
    }
}
