package gov.va.med.cds.ws.saml.util;

import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlUtility {
	
	
	public static Element getFirstElement(Node parent) {
        Node n = parent.getFirstChild();
        while (n != null && Node.ELEMENT_NODE != n.getNodeType()) {
            n = n.getNextSibling();
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }
   
   
	public static String assertionToString(Element assertionElement) throws WSSecurityException {
        String assertion = "";
   		if (assertionElement != null) {
   			assertion = DOM2Writer.nodeToString(assertionElement);
        }
        return assertion;
    }


}
