/******************************************************************************
   NAME:       new_vitals_load3x_arms.sql
   PURPOSE:    This script will create Vitals records that map to 
               VHIM version 3.6.2  
   ADDITIONAL INFORMATION:
    
   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.1        07/11/2007  M. Jacobsen      - Initial Release
******************************************************************************/
set serveroutput on
DECLARE
   random_num                   NUMBER          := 0;
   random_num2                  NUMBER          := 0;
   random_num3                  NUMBER          := 0;
   random_num4                  NUMBER          := 0;
   r_loop                       NUMBER;
   nullifyppid                  NUMBER;
   authorppid                   NUMBER;
   vital_seq_id_val             NUMBER;
   pract_part_seq_id_val        NUMBER;
   qualifier_seq_id_val         NUMBER;
   nullrsn_seq_id_val           NUMBER;
   patient_id                   NUMBER;
   ppa_date                     VARCHAR2 (30);
   ppn_date                     VARCHAR2 (30);
   upd_date                     VARCHAR2 (30);
   collection_tm                VARCHAR2 (30);
   observation_tm               VARCHAR2 (30);
   obschar_code_d               VARCHAR2 (100);
   obschar_code_v               VARCHAR2 (20);
   alt_codsys_obschar           VARCHAR2 (50);
   alt_display_obschar          VARCHAR2 (100);
   alt_code_obschar             VARCHAR2 (30);
   alt_reason_obschar           VARCHAR2 (100);
   status_code_d                VARCHAR2 (100);
   status_code_v                VARCHAR2 (20);
   alt_codsys_st                VARCHAR2 (50);
   alt_display_st               VARCHAR2 (100);
   alt_code_st                  VARCHAR2 (30);
   alt_reason_st                VARCHAR2 (100);
   patstat_code_d               VARCHAR2 (100);
   patstat_code_v               VARCHAR2 (20);
   alt_codsys_patstat           VARCHAR2 (50);
   alt_display_patstat          VARCHAR2 (100);
   alt_code_patstat             VARCHAR2 (30);
   alt_reason_patstat           VARCHAR2 (100);
   hosploc_cd_d                 VARCHAR2 (100);
   hosploc_cd_v                 VARCHAR2 (20);
   alt_codsys_hosploc           VARCHAR2 (50);
   alt_display_hosploc          VARCHAR2 (100);
   alt_code_hosploc             VARCHAR2 (30);
   alt_reason_hosploc           VARCHAR2 (100);
   nullrsn_code_d               VARCHAR2 (100);
   nullrsn_code_v               VARCHAR2 (20);
   alt_codsys_nullrsn           VARCHAR2 (50);
   alt_display_nullrsn          VARCHAR2 (100);
   alt_code_nullrsn             VARCHAR2 (30);
   alt_reason_nullrsn           VARCHAR2 (100);
   qualifier_value              VARCHAR2 (100);
   v_vpid                       VARCHAR2 (30);
   patient_seq_id_val           NUMBER;
   starting_patient_vpid        NUMBER;
   fixed_date			        DATE;
   
   
BEGIN
   dbms_output.enable(null);
   DBMS_RANDOM.SEED(42); -- add seeding for same random numbers.
   DBMS_OUTPUT.put_line (   'Vitals Start Time := '|| TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss'));

   fixed_date := TO_DATE('07-04-07 17:07:06','MM-DD-YY HH24:MI:SS');

-- Set starting_patient_vpid
   IF &3 <= 0 
   THEN
       starting_patient_vpid :=1;
   ELSE
       starting_patient_vpid := &3 - 1;
   END IF;

-- Loop thru how many allergies you want per patient
   FOR z IN 1 .. &1
   LOOP
       -- Loop thru how many patients to assign allergies to
       FOR jj in 1 .. &2
	   LOOP

         -- Null variables
         alt_codsys_obschar     := NULL;
         alt_code_obschar       := NULL;
         alt_display_obschar    := NULL;
         alt_reason_obschar     := NULL;
         alt_codsys_st          := NULL;
         alt_code_st            := NULL;
         alt_display_st         := NULL;
         alt_reason_st          := NULL;
         alt_codsys_patstat     := NULL;
         alt_code_patstat       := NULL;
         alt_display_patstat    := NULL;
         alt_reason_patstat     := NULL;
         
         -- Set Observered Characteristic information
         random_num := round(DBMS_RANDOM.VALUE (1, 4));
         CASE random_num
            WHEN '1' THEN
             obschar_code_d := 'WEIGHT';
             obschar_code_v := 30000;
            WHEN '2' THEN
             obschar_code_d := 'TEMPERATURE';
             obschar_code_v := 30001;
            WHEN '3' THEN
             obschar_code_d := 'BLOOD PRESSURE';
             obschar_code_v := 30002;
            ELSE
             random_num2 := round(dbms_random.value(1,20));
             CASE random_num2
              WHEN '1' THEN
               obschar_code_d       := NULL;
               obschar_code_v       := NULL;
               alt_codsys_obschar   := 'HL7';
               alt_code_obschar     := '902109238';
               alt_display_obschar  := 'UNKNOWN';
               alt_reason_obschar   := 'INCOMING FROM PRIVATE SECTOR';
              ELSE
               obschar_code_d := 'PULSE';
               obschar_code_v := 30003;
              END CASE;
         END CASE;
         
         -- Set status_code_displayname
         random_num := round(DBMS_RANDOM.VALUE (1, 3));

         CASE random_num
            WHEN '1' THEN
               status_code_d := 'ACTIVE';
               status_code_v := '25';
            WHEN '2' THEN
               status_code_d := 'OPEN';
               status_code_v := '11';
            ELSE
               random_num2 := round(DBMS_RANDOM.VALUE (1, 20));
               IF random_num2 = 1
               THEN
                   status_code_d      := NULL;
                   status_code_v      := NULL;
                   alt_codsys_st      := 'HL7';
                   alt_display_st     := 'UNKNOWN';
                   alt_code_st        := '8432165987';
                   alt_reason_st      := 'INCOMING FROM PRIVATE SECTOR';
               ELSE 
                   status_code_d      := 'WAIT';
                   status_code_v      := '37';
               END IF;
         END CASE;

         -- load patient state observation
         random_num := ROUND (DBMS_RANDOM.VALUE (1, 10));

         IF random_num > 2
         THEN
            random_num2 := ROUND(DBMS_RANDOM.VALUE(1,4));
            
            CASE random_num2
              WHEN '1' THEN 
                patstat_code_d  := 'EXERCISING';
                patstat_code_v  := '654456556';
              WHEN '2' THEN 
                patstat_code_d  := 'RESTING';
                patstat_code_v  := '654456553';
              WHEN '3' THEN 
                patstat_code_d  := 'UNCONSCIOUS';
                patstat_code_v  := '654456552';
              ELSE 
                patstat_code_d  := NULL;
                patstat_code_v  := NULL;
                alt_codsys_patstat  := 'HL7';
                alt_code_patstat    := '39829811';
                alt_display_patstat := 'UNKNOWN';
                alt_reason_patstat  := 'INCOMING FROM PRIVATE SECTOR';
              END CASE;
         ELSE
            patstat_code_d  := NULL;
            patstat_code_v  := NULL;
         END IF;

         -- Set hospital code
         random_num := round(DBMS_RANDOM.VALUE (1, 10));

         CASE random_num
            WHEN '1' THEN
               hosploc_cd_d := 'VA SALT LAKE CITY HEALTH CARE SYSTEM';
               hosploc_cd_v := '660';
            WHEN '2' THEN
               hosploc_cd_d := 'TUSCALOOSA VA MEDICAL CENTER';
               hosploc_cd_v := '679';
            WHEN '3' THEN
               hosploc_cd_d := 'CENTRAL TEXAS VETERANS HEALTH CARE SYSTEM';
               hosploc_cd_v := '674';
            WHEN '4' THEN
               hosploc_cd_d := 'PHILADELPHIA VA MEDICAL CENTER';
               hosploc_cd_v := '642';
            WHEN '5' THEN
               hosploc_cd_d := 'CINCINNATI VA MEDICAL CENTER';
               hosploc_cd_v := '539';
            WHEN '6' THEN
               hosploc_cd_d := 'JAMES J. PETERS VA MEDICAL CENTER';
               hosploc_cd_v := '526';
            WHEN '7' THEN
               hosploc_cd_d := 'VA GULF COAST VETERANS HEALTH CARE SYSTEM';
               hosploc_cd_v := '520';
            WHEN '8' THEN
               hosploc_cd_d := 'RICHARD L. ROUDEBUSH VA MEDICAL CENTER';
               hosploc_cd_v := '583';
            WHEN '9' THEN
               hosploc_cd_d := 'MIAMI VA HEALTHCARE SYSTEM';
               hosploc_cd_v := '546';
            ELSE
               random_num2 := round(DBMS_RANDOM.VALUE (1, 10));
               IF random_num2 = 1
               THEN
                   hosploc_cd_d         := NULL;
                   hosploc_cd_v         := NULL;
                   alt_codsys_hosploc   := 'HL7';
                   alt_display_hosploc  := 'UNKNOWN';
                   alt_code_hosploc     := '0226549681';
                   alt_reason_hosploc   := 'SAINT MARK';
               ELSE 
                   hosploc_cd_d := 'JONATHAN M. WAINWRIGHT MEMORIAL VA MEDICAL CENTER';
                   hosploc_cd_v := '687';
               END IF;
         END CASE;
         
         random_num  := DBMS_RANDOM.VALUE (-2, -5);
         random_num2 := DBMS_RANDOM.VALUE (-2, -5);
         random_num3 := DBMS_RANDOM.VALUE (-2, -5);
         random_num4 := DBMS_RANDOM.VALUE (-2, -5);

         SELECT TO_CHAR (fixed_date + random_num, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num2, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num3, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date + random_num4, 'yyyymmddhh24miss'),
                TO_CHAR (fixed_date, 'yyyymmddhh24miss'),
                ROUND (DBMS_RANDOM.VALUE (1, 50000))
           INTO ppa_date,
                ppn_date,
                collection_tm,
                observation_tm,
                upd_date,
                patient_id
           FROM DUAL;

         -- get author practitioner
         SELECT pract_part_seq_id.NEXTVAL
           INTO authorppid
           FROM DUAL;
         
         insert_practpart.insert_message( ppa_date, authorppid );

         SELECT vital_seq_id.NEXTVAL
           INTO vital_seq_id_val
           FROM DUAL;
           
         -- get Patient seq id
         SELECT patient_information_seq_id.NEXTVAL
           INTO patient_seq_id_val
           FROM DUAL;

         v_vpid := 'test_vpid_' || to_char(jj + starting_patient_vpid);
         
         -- Load Patient Record
         INSERT INTO PATIENT_information (  PATIENT_information_ID, 	
                                name_PREFIX, 	
                                name_GIVEN, 	
                                name_NICKNAME, 	
                                name_FAMILY, 	
                                name_SUFFIX, 	
                                name_TITLE, 	
                                name_FORMATTED, 	
                                name_MIDDLE, 	
                                birthdate,
                                gender,
                                marital_status,
                                mother_maiden_name,
                                religion,                           
                                LAST_UPDATED_DTTZ
                              )
         VALUES (
                   patient_seq_id_val                                          -- PATIENT_ID
                 , NULL                                                        -- PREFIX_NM	
                 , NULL                                                        -- GIVEN_NM	
                 , NULL                                                        -- NICKNAME_NM	
                 , dbms_random.string ('U',trunc(dbms_random.value(1,40)))     -- FAMILY_NM	
                 , NULL                                                        -- SUFFIX_NM	
                 , NULL                                                        -- TITLE_NM	
                 , NULL                                                        -- FORMATTED_NM	
                 , NULL                                                        -- MIDDLE_NM	
                 , fixed_date - (365*(dbms_random.value(30,100)))              -- birthdate	
                 , 'FEMALE'                                                    -- gender	
                 , 'SINGLE'                                                    -- marital_status	
                 , dbms_random.string ('U',trunc(dbms_random.value(1,40)))     -- mother_maiden_name	
                 , null                                                        -- religion
                 , SYSTIMESTAMP                                                -- last_updated_dttz
                );
         
--dbms_output.put_line('what is patient_vpid?  ' || patient_vpid);         

         INSERT INTO vital
                     (     
                          VITAL_ID
                        , PATIENT_information_ID  
                        , AUTHOR_PPID 
                        , NULLIFIER_PPID 
                        , patient_source_id
                        , patient_namespace_id
                        , IDENTITY_ENTITYID      
                        , IDENTITY_NAMESPACEID   
                        , IDENTITY_UNIVERSALID   
                        , IDENTITY_UNIVERSALTYP  
                        , VITAL_VAL              
                        , VITAL_UOFM             
                        , COLLECTION_SESSION_TM  
                        , OBSERVATION_TM                    
                        , OBSERVED_CHAR_VALSET_VUID         
                        , OBSERVED_CHAR_CONCEPT_VUID        
                        , OBSERVED_CHAR_DSGNTN_VUID         
                        , OBSERVED_CHAR_DSPLYTXT            
                        , OBSERVED_CHAR_ALT_CODSYS          
                        , OBSERVED_CHAR_ALT_CODE            
                        , OBSERVED_CHAR_ALT_DSPLYTXT        
                        , OBSERVED_CHAR_ALT_REASON          
                        , STATUS_VALSET_VUID                
                        , STATUS_CONCEPT_VUID               
                        , STATUS_DSGNTN_VUID                
                        , STATUS_DSPLYTXT                   
                        , STATUS_ALT_CODSYS                 
                        , STATUS_ALT_CODE                   
                        , STATUS_ALT_DSPLYTXT               
                        , STATUS_ALT_REASON                 
                        , SUPP_O2_RATE_CONCENTRATION        
                        , HOSPITAL_LOC_VALSET_VUID          
                        , HOSPITAL_LOC_CONCEPT_VUID         
                        , HOSPITAL_LOC_DSGNTN_VUID          
                        , HOSPITAL_LOC_DSPLYTXT             
                        , HOSPITAL_LOC_ALT_CODSYS           
                        , HOSPITAL_LOC_ALT_CODE             
                        , HOSPITAL_LOC_ALT_DSPLYTXT         
                        , HOSPITAL_LOC_ALT_REASON           
                        , HOMEAPPL_SRLNBR_ENTITYID     
                        , HOMEAPPL_SRLNBR_NAMESPACEID  
                        , HOMEAPPL_SRLNBR_UNIVERSALID  
                        , HOMEAPPL_SRLNBR_UNIVERSALTYP 
                        , HOMEAPPL_NAME                     
                        , MEASDEVICE_SRLNBR_ENTITYID   
                        , MEASDEVICE_SRLNBR_NAMESPACEID
                        , MEASDEVICE_SRLNBR_UNIVERSALID
                        , MEASDEVICE_SRLNBR_UNIVERSALTYP
                        , MEASDEVICE_NAME                   
                        , RECORD_VERSION                
                        , RECORD_UPDATE_TM                  
                        , LAST_UPDATED_DTTZ             
                     )
              VALUES (  
                          vital_seq_id_val                                                          -- VITAL_ID
                        , patient_seq_id_val                                                        -- PATIENT_information_ID  
                        , authorppid                                                                -- AUTHOR_PPID 
                        , NULL                                                                      -- NULLIFIER_PPID 
                        , v_vpid                                                                    -- patient_source_id
                        , 'VA.GOV-605'                                                              -- patient_namespace_id
                        , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- IDENTITY_ENTITYID      
                        , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- IDENTITY_NAMESPACEID   
                        , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- IDENTITY_UNIVERSALID   
                        , 'VISN'||ROUND(DBMS_RANDOM.VALUE(1, 21))||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- IDENTITY_UNIVERSALTYP  
                        , dbms_random.string ('U',trunc(dbms_random.value(1,100)))                  -- VITAL_VAL              
                        , NULL                                                                      -- VITAL_UOFM             
                        , collection_tm                                                             -- COLLECTION_SESSION_TM  
                        , observation_tm                                                            -- OBSERVATION_TM                    
                        , obschar_code_v                                                            -- OBSERVED_CHAR_VALSET_VUID         
                        , NULL                                                                      -- OBSERVED_CHAR_CONCEPT_VUID        
                        , NULL                                                                      -- OBSERVED_CHAR_DSGNTN_VUID         
                        , obschar_code_d                                                            -- OBSERVED_CHAR_DSPLYTXT            
                        , alt_codsys_obschar                                                        -- OBSERVED_CHAR_ALT_CODSYS          
                        , alt_code_obschar                                                          -- OBSERVED_CHAR_ALT_CODE            
                        , alt_display_obschar                                                       -- OBSERVED_CHAR_ALT_DSPLYTXT        
                        , alt_reason_obschar                                                        -- OBSERVED_CHAR_ALT_REASON          
                        , status_code_v                                                             -- STATUS_VALSET_VUID                
                        , NULL                                                                      -- STATUS_CONCEPT_VUID               
                        , NULL                                                                      -- STATUS_DSGNTN_VUID                
                        , status_code_d                                                             -- STATUS_DSPLYTXT                   
                        , alt_codsys_st                                                             -- STATUS_ALT_CODSYS                 
                        , alt_code_st                                                               -- STATUS_ALT_CODE                   
                        , alt_display_st                                                            -- STATUS_ALT_DSPLYTXT               
                        , alt_reason_st                                                             -- STATUS_ALT_REASON                 
                        , dbms_random.string ('U',trunc(dbms_random.value(1,100)))                  -- SUPP_O2_RATE_CONCENTRATION        
                        , hosploc_cd_v                                                              -- HOSPITAL_LOC_VALSET_VUID          
                        , NULL                                                                      -- HOSPITAL_LOC_CONCEPT_VUID         
                        , NULL                                                                      -- HOSPITAL_LOC_DSGNTN_VUID          
                        , hosploc_cd_d                                                              -- HOSPITAL_LOC_DSPLYTXT             
                        , alt_codsys_hosploc                                                        -- HOSPITAL_LOC_ALT_CODSYS           
                        , alt_code_hosploc                                                          -- HOSPITAL_LOC_ALT_CODE             
                        , alt_display_hosploc                                                       -- HOSPITAL_LOC_ALT_DSPLYTXT         
                        , alt_reason_hosploc                                                        -- HOSPITAL_LOC_ALT_REASON           
                        , 'HOME'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- HOMEAPPL_SRLNBR_ENTITYID     
                        , 'HOME'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- HOMEAPPL_SRLNBR_NAMESPACEID  
                        , 'HOME'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- HOMEAPPL_SRLNBR_UNIVERSALID  
                        , 'HOME'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- HOMEAPPL_SRLNBR_UNIVERSALTYP 
                        , dbms_random.string ('U',trunc(dbms_random.value(1,100)))                  -- HOMEAPPL_NAME                     
                        , 'MEASURE'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- MEASDEVICE_SRLNBR_ENTITYID   
                        , 'MEASURE'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- MEASDEVICE_SRLNBR_NAMESPACEID
                        , 'MEASURE'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- MEASDEVICE_SRLNBR_UNIVERSALID
                        , 'MEASURE'||'_'||ROUND(DBMS_RANDOM.VALUE (1,99999999))||'.'||vital_seq_id_val -- MEASDEVICE_SRLNBR_UNIVERSALTYP
                        , dbms_random.string ('U',trunc(dbms_random.value(1,100)))                  -- MEASDEVICE_NAME                   
                        , 1                                                                         -- RECORD_VERSION                
                        , upd_date                                                                  -- RECORD_UPDATE_TM                  
                        , SYSTIMESTAMP                                                              -- LAST_UPDATED_DTTZ
                     );

         -- check to see if we want to load a NULLIFIER
         random_num := round(dbms_random.value(1,100));
         IF random_num = 1 
         THEN 
            random_num2 := round(dbms_random.value(1,100));
            IF random_num2 > 94
            THEN
                r_loop := 2;
            ELSE
                r_loop := 1;
            END IF;
            
            FOR rr in 1..r_loop
            LOOP   
                IF rr = 1
                THEN
                    nullrsn_code_d      := 'WRONG PATIENT';
                    nullrsn_code_v      := '239082398547';
                    alt_codsys_nullrsn  := NULL;
                    alt_code_nullrsn    := NULL;
                    alt_display_nullrsn := NULL;
                    alt_reason_nullrsn  := NULL;
                ELSE
                    nullrsn_code_d      := NULL;
                    nullrsn_code_v      := NULL;
                    alt_codsys_nullrsn  := 'UNKNOWN';
                    alt_code_nullrsn    := '57221093923';
                    alt_display_nullrsn := 'INVALID READING';
                    alt_reason_nullrsn  := 'UNKNOWN REASON';
                END IF;
                
                -- load r_loop nullify reasons
                INSERT INTO NULLIFY_REASON (
                                              NULLIFY_REASON_ID
                                            , VITAL_ID
                                            , NULLIFY_REASON_VALSET_VUID
                                            , NULLIFY_REASON_CONCEPT_VUID
                                            , NULLIFY_REASON_DSGNTN_VUID
                                            , NULLIFY_REASON_DSPLYTXT
                                            , NULLIFY_REASON_ALT_CODSYS
                                            , NULLIFY_REASON_ALT_CODE
                                            , NULLIFY_REASON_ALT_DSPLYTXT
                                            , NULLIFY_REASON_ALT_REASON
                                            , LAST_UPDATED_DTTZ
                                           )
                                    VALUES (
                                              nullify_reason_seq_id.NEXTVAL                         --  NULLIFY_REASON_ID
                                            , vital_seq_id_val                                      -- VITAL_ID
                                            , nullrsn_code_v                                        -- NULLIFY_REASON_VALSET_VUID
                                            , NULL                                                  -- NULLIFY_REASON_CONCEPT_VUID
                                            , NULL                                                  -- NULLIFY_REASON_DSGNTN_VUID
                                            , nullrsn_code_d                                        -- NULLIFY_REASON_DSPLYTXT
                                            , alt_codsys_nullrsn                                    -- NULLIFY_REASON_ALT_CODSYS
                                            , alt_code_nullrsn                                      -- NULLIFY_REASON_ALT_CODE
                                            , alt_display_nullrsn                                   -- NULLIFY_REASON_ALT_DSPLYTXT
                                            , alt_reason_nullrsn                                    -- NULLIFY_REASON_ALT_REASON
                                            , SYSTIMESTAMP                                          -- LAST_UPDATED_DTTZ
                                           );
            END LOOP; 

            -- get author practitioner
            SELECT pract_part_seq_id.NEXTVAL
              INTO nullifyppid
              FROM DUAL;
             
            insert_practpart.insert_message( ppn_date, nullifyppid );
                
            -- update vital nullifier id
            UPDATE vital SET NULLIFIER_PPID = nullifyppid
            WHERE vital_id = vital_seq_id_val;
                
         END IF;
         
         -- load 0 to many qualifiers
         random_num := round(dbms_random.value(0,2));
         IF random_num = 0 
         THEN 
            random_num2 := round(dbms_random.value(1,3));
            FOR j IN 1 .. random_num2
            LOOP
               -- Set body_site
               random_num3 := ROUND(DBMS_RANDOM.VALUE (1, 15));

               CASE random_num3
                  WHEN '1' THEN
                     qualifier_value := 'DOPPLER';
                  WHEN '2' THEN
                     qualifier_value := 'LEFT';
                  WHEN '3' THEN
                     qualifier_value := 'RIGHT';
                  WHEN '4' THEN
                     qualifier_value := 'ARM';
                  WHEN '5' THEN
                     qualifier_value := 'LEG';
                  WHEN '6' THEN
                     qualifier_value := 'BUTTOCKS';
                  WHEN '7' THEN
                     qualifier_value := 'STANDING';
                  WHEN '8' THEN
                     qualifier_value := 'SITTING';
                  WHEN '9' THEN
                     qualifier_value := 'PRONE';
                  WHEN '10' THEN
                     qualifier_value := 'KNEE';
                  WHEN '11' THEN
                     qualifier_value := 'FOREARM';
                  WHEN '12' THEN
                     qualifier_value := 'FOOT';
                  WHEN '13' THEN
                     qualifier_value := 'HAND';
                  WHEN '14' THEN
                     qualifier_value := 'KNEELING';
                  ELSE
                     qualifier_value := 'STOMACH';
               END CASE;

               
               -- insert body_site record
               INSERT INTO QUALIFIER
                              (   QUALIFIER_ID
                                , VITAL_ID
                                , QUALIFIER_VAL
                                , LAST_UPDATED_DTTZ   
                              )
               VALUES (
                         qualifier_seq_id.NEXTVAL                                               -- QUALIFIER_ID 
                       , vital_seq_id_val                                                       -- VITAL_ID
                       , qualifier_value                                                        -- QUALIFIER_VAL
                       , SYSTIMESTAMP                                                           -- LAST_UPDATED_DTTZ
                       );
               

            END LOOP;
         END IF;

       END LOOP;
       COMMIT;
   END LOOP;

   DBMS_OUTPUT.put_line (' ');
   DBMS_OUTPUT.put_line (   'Vitals End Time := ' || TO_CHAR (SYSDATE, 'MM/DD/YY hh:mi:ss') );
END;
/