

package gov.va.med.cds.client.functional.logging;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.junit.runners.BeforeTestsOnce;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;

import javax.annotation.Resource;


/**
 * @author vhaislchittv
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/client/functional/logging/appContext.xml" } )
public class JmsAppenderLoggerTest
    extends
        AbstractBaseTest
{

    private static String errorMessage = "SpringAwareAppenderProxy#19299299#FUNCTIONALTEST#Message";
    private static String errorMessageDb = "SpringAwareDbAppender#19399399#FUNCTIONALTEST#Message";
    private JdbcTemplate loggerJdbcTemplate;
    private static final String queryRequestId = "19299299";
    private static final String queryRequestIdDb = "19399399";
    static private int expectedReadResult = 1;


    @BeforeTestsOnce
    @Suite( groups = { "smoketest" } )
    public void beforeJmsAppenderLoggerTestClassSetUp( )
        throws Exception
    {

        try
        {
            loggerJdbcTemplate.update( "delete from cds_application_log where request_id = ?", new Object[] { queryRequestId } );
        }
        catch ( Exception e )
        {
            logger.error( String.format( "Couldn't delete the record: %d", queryRequestId ) );
        }
        try
        {
            loggerJdbcTemplate.update( "delete from cds_application_log where request_id = ?", new Object[] { queryRequestIdDb } );
        }
        catch ( Exception ee )
        {
            logger.error( String.format( "Couldn't delete the record: %d", queryRequestIdDb ) );
        }
    }


    public JmsAppenderLoggerTest( )
    {
        super( System.getProperty( "log4j.properties" ) );
    }


    @Test
    @Suite( groups = { "smoketest" } )
    public void testLogErrors( )
        throws InterruptedException
    {
        //log.error( errorMessage );
        Log springLog = LogFactory.getLog( "gov.va.med.cds" );
        springLog.error( errorMessage );
        Thread.sleep( 9000 );

        Log dbLog = LogFactory.getLog( "gov.va.med.cds.log4j" );
        dbLog.fatal( errorMessageDb );
    }


    @Test
    @Suite( groups = { "smoketest" }, order = 1, dependsOnMethods = { "testLogErrors" } )
    public void testReadLoggedMessages( )
    {
        int returnValue = loggerJdbcTemplate.queryForObject( "select count(*) from cds_application_log where REQUEST_ID = ?",
                        new Object[] { queryRequestId }, Integer.class );
        assertEquals( expectedReadResult, returnValue );

        returnValue = loggerJdbcTemplate.queryForObject( "select count(*) from cds_application_log where REQUEST_ID = ?",
                        new Object[] { queryRequestIdDb }, Integer.class );
        assertEquals( expectedReadResult, returnValue );
    }


    @Test
    @Suite( groups = { "smoketest" }, order = 2, dependsOnMethods = { "testReadLoggedMessages" } )
    public void testDeleteLoggedMessages( )
    {
        try
        {
            this.loggerJdbcTemplate.update( "delete from cds_application_log where request_id = ?", new Object[] { queryRequestId } );
        }
        catch ( Exception e )
        {
            logger.error( String.format( "Couldn't delete the record: %d", queryRequestId ) );
        }
        try
        {
            this.loggerJdbcTemplate.update( "delete from cds_application_log where request_id = ?", new Object[] { queryRequestIdDb } );
        }
        catch ( Exception ee )
        {
            logger.error( String.format( "Couldn't delete the record: %d", queryRequestIdDb ) );
        }
    }


    @Resource
    public void setLoggerJdbcTemplate( JdbcTemplate loggerJdbcTemplate )
    {
        this.loggerJdbcTemplate = loggerJdbcTemplate;
    }


    protected JdbcTemplate getLoggerJdbcTemplate( )
    {
        return this.loggerJdbcTemplate;
    }
}
