

package gov.va.med.cds.ejb;


import gov.va.med.cds.audit.VhimRequestAuditLoggerInterface;
import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.clinicaldata.vhim400.ClinicalDataResponse400;
import gov.va.med.cds.exception.RuntimeMDBOnMessageException;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.response.util.ResponseErrorSectionExtractor;
import gov.va.med.cds.testharness.AbstractBaseTest;

import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.test.context.ContextConfiguration;

import weblogic.jms.common.BytesMessageImpl;
import weblogic.jms.common.ObjectMessageImpl;
import weblogic.jms.common.TextMessageImpl;


/*@RunWith( SuiteAwareSpringRunner.class )
@ContextConfiguration( locations = { "classpath:gov/va/med/cds/config/logAndSwallowAspectContext.xml" } )*/
public class CdsVhimClinicalMdbTest
    extends
        AbstractBaseTest
{
    private static String TEMPLATE_ID = "TEMPLATE_ID";
    private static String REQUEST_ID = "REQUEST_ID";
    private static String SENDING_FACILITY = "SENDING_FACILITY";
    private static String SENDING_APPLICATION = "SENDING_APPLICATION";
    private static String MESSAGE_DATE_TIME = "MESSAGE_DATE_TIME";
    private static String RESPONSE_WITH_NO_ERROR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>AllergyAssessmentCreate40020</templateId><requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId><errorSection/></clinicaldata:ClinicalData>";
    private static String RESPONSE_WITH_UNIQUE_CONSTRAINT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>AllergyAssessmentCreate40020</templateId><requestId>E851B78E-0807-1A28-E86C-E1B362624068</requestId><errorSection><fatalErrors><errorId>55253592077</errorId><exception>gov.va.med.cds.persistence.hibernate.HibernateConstraintViolationException</exception><exceptionMessage>HDRII_CONSTRAINT_VIOLATED</exceptionMessage><errorCode>HDRII_CONSTRAINT_VIOLATED</errorCode><displayMessage>HDR2 Integrity constraint violated:BaseBatchUpdateException: [BEA][Oracle JDBCDriver][Oracle]ORA-00001: unique constraint(ALLERGIES.ALLERGY_RECORDID_UNQ_CK) violated</displayMessage></fatalErrors></errorSection></clinicaldata:ClinicalData>";
    private static String RESPONSE_WITH_SCHEMA_VALIDATION_FAILED = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>VitalsignsCreateOrUpdate40060</templateId><requestId>5A2B3C920D5F3</requestId><errorSection><fatalErrors><errorId>5A2B3C920D5F3</errorId><exception>gov.va.med.cds.xml.schema.SchemaValidationException</exception><exceptionMessage>SCHEMA_VALIDATION_FAILED</exceptionMessage><errorCode>SCHEMA_VALIDATION_FAILED</errorCode><displayMessage>Schema validation failed because of cvc-complex-type.2.4.a: Invalid content was found starting with element 'patient'. One of '{&quot;&quot;:recordIdentifier}' is expected.</displayMessage></fatalErrors></errorSection></clinicaldata:ClinicalData>";

    // injected by Spring
    private ResponseErrorSectionExtractor responseErrorSectionExtractor;


    /*@Test
    @Suite( groups = "checkintest" )
    public void testSetMessageDrivenContext()
    {
    	MessageDrivenContext messageDrivenContext = EasyMock.createMock(MessageDrivenContext.class);
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();
        cdsVhimClinicalMdb.setMessageDrivenContext(messageDrivenContext);
    }*/
    
   /* @Test
    @Suite( groups = "checkintest" )*/
    public void testOnMessageWithBytesMessage( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        BytesMessage message = new BytesMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "DNS    .DNS        URL        " );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142932-0800" );
        message.writeBytes( "<VHIM Payload>".getBytes() );
        message.reset();

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_NO_ERROR );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );
        
        cdsVhimClinicalMdb.setPersistOriginalMessage( true );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        cdsVhimClinicalMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock, responseJmsTemplateMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


   /* @Test
    @Suite( groups = "checkintest" )*/
    public void testOnMessageWithTextMessage( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "DNS    .DNS        URL        " );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142932-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_NO_ERROR );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );

        cdsVhimClinicalMdb.setPersistOriginalMessage( true );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        cdsVhimClinicalMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock, responseJmsTemplateMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


   /* @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )*/
    public void testOnMessageWithObjectMessage( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();
        cdsVhimClinicalMdb.setClinicalDataResponse(new ClinicalDataResponse400());
        
        ObjectMessage message = new ObjectMessageImpl();

        cdsVhimClinicalMdb.onMessage( message );
    }


   /* @Test( expected = RuntimeException.class )
    @Suite( groups = "checkintest" )*/
    public void testOnMessageThrowingRuntimeExceptionByAuditClobStore( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "TemplateId" );
        message.setStringProperty( REQUEST_ID, "RequestId" );
        message.setStringProperty( SENDING_FACILITY, "SendingFacility" );
        message.setStringProperty( SENDING_APPLICATION, "SendingApp" );
        message.setStringProperty( MESSAGE_DATE_TIME, "MessageDtTm" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( "DBQCreate1", EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "TemplateId", "RequestId" ) ).andReturn( RESPONSE_WITH_NO_ERROR );

        cdsVhimClinicalMdb.setPersistOriginalMessage( true );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


    /*@Test( expected = RuntimeException.class )
    @Suite( groups = "checkintest" )*/
    public void testOnMessageThrowingRuntimeExceptionByCdsService( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "TemplateId" );
        message.setStringProperty( REQUEST_ID, "RequestId" );
        message.setStringProperty( SENDING_FACILITY, "SendingFacility" );
        message.setStringProperty( SENDING_APPLICATION, "SendingApp" );
        message.setStringProperty( MESSAGE_DATE_TIME, "MessageDtTm" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "TemplateId", "RequestId" ) ).andThrow( new RuntimeException() );

        cdsVhimClinicalMdb.setPersistOriginalMessage( false );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


   /* @Test
    @Suite( groups = "checkintest" )*/
    public void testOnMessageWithUniqueConstraintExceptionThrownByCdsService( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "DNS    .DNS        URL        " );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142932-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_UNIQUE_CONSTRAINT );
        
        Destination destinationMock = EasyMock.createNiceMock( Destination.class );
        
        JmsTemplate responseJmsTemplateMock = EasyMock.createNiceMock( JmsTemplate.class );
        EasyMock.expect( responseJmsTemplateMock.getDefaultDestination()).andReturn( destinationMock );
        responseJmsTemplateMock.send( (Destination)EasyMock.anyObject(), (MessageCreator)EasyMock.anyObject() );

        cdsVhimClinicalMdb.setPersistOriginalMessage( true );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );
        cdsVhimClinicalMdb.setResponseJmsTemplate( responseJmsTemplateMock );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock, responseJmsTemplateMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


   /* @Test( expected = RuntimeMDBOnMessageException.class )
    @Suite( groups = "checkintest" )*/
    public void testOnMessageWithSchemaValidationExceptionThrownByCdsService( )
        throws Exception
    {
        CdsVhimCreateClinicalDataMdb cdsVhimClinicalMdb = new CdsVhimCreateClinicalDataMdb();

        TextMessage message = new TextMessageImpl();
        message.setStringProperty( TEMPLATE_ID, "AllergyAssessmentCreate40020" );
        message.setStringProperty( REQUEST_ID, "55253592039" );
        message.setStringProperty( SENDING_FACILITY, "DNS    .DNS        URL        " );
        message.setStringProperty( SENDING_APPLICATION, "HDRADAS" );
        message.setStringProperty( MESSAGE_DATE_TIME, "20070316142932-0800" );
        message.setText( "<VHIM Payload>" );

        VhimRequestAuditLoggerInterface vhimRequestAuditLoggerMock = EasyMock.createMock( VhimRequestAuditLoggerInterface.class );
        vhimRequestAuditLoggerMock.auditWriteRequest( EasyMock.isA(String.class), EasyMock.isA(String.class), EasyMock.isA(String.class) );
        EasyMock.expectLastCall();

        ClinicalDataServiceInterface cdsServiceMock = EasyMock.createMock( ClinicalDataServiceInterface.class );
        EasyMock.expect( cdsServiceMock.createClinicalData( "<VHIM Payload>", "AllergyAssessmentCreate40020", "55253592039" ) ).andReturn(
                        RESPONSE_WITH_SCHEMA_VALIDATION_FAILED );

        cdsVhimClinicalMdb.setPersistOriginalMessage( true );
        cdsVhimClinicalMdb.setVhimRequestAuditLogger( vhimRequestAuditLoggerMock );
        cdsVhimClinicalMdb.setCdsService( cdsServiceMock );
        cdsVhimClinicalMdb.setResponseErrorSectionExtractor( responseErrorSectionExtractor );

        EasyMock.replay( vhimRequestAuditLoggerMock, cdsServiceMock );

        cdsVhimClinicalMdb.onMessage( message );
    }


    @javax.annotation.Resource
    public void setResponseErrorSectionExtractor( ResponseErrorSectionExtractor responseErrorSectionExtractor )
    {
        this.responseErrorSectionExtractor = responseErrorSectionExtractor;
    }
}
