

package gov.va.med.cds.xml.schema;


import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class SchemaValidationExceptionTest
{
    @Test( expected = SchemaException.class )
    @Suite( groups = "checkintest" )
    public void testSchemaException( )
    {
        throw new SchemaException( ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE );
    }


    @Test( expected = SchemaValidationException.class )
    @Suite( groups = "checkintest" )
    public void testSchemaExceptionWithThowable( )
    {
        throw new SchemaValidationException( ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE, new Exception() );
    }


    @Test( expected = SchemaException.class )
    @Suite( groups = "checkintest" )
    public void testSchemaExceptionWithCustomMessage( )
    {
        throw new SchemaException( ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE, "TestSchema", "Invalid Schema" );
    }


    @Test( expected = SchemaValidationException.class )
    @Suite( groups = "checkintest" )
    public void testSchemaExceptionWithThrowableAndCustomMessage( )
    {
        throw new SchemaValidationException( ErrorCodeEnum.UNABLE_TO_LOAD_SCHEMAS_INTO_RESOURCE, new Exception(), "Invalid Schema" );
    }
}
