

package gov.va.med.cds.transaction;


import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkException;
import commonj.work.WorkItem;

import java.util.List;


public class SerialWorkManager
    implements
        WorkManagerInterface
{
    public WorkItem schedule( final Work work )
    {
        work.run();
        return new WorkItem() {

        	public int compareTo(Object o) {
        		return 1;
        	}
        	
        	public Work getResult() throws WorkException {
        		return work;
        	}
        	
        	public int getStatus() {
        		return WorkEvent.WORK_COMPLETED;
        	}
        };
    }

    
    @Override
    public boolean waitForAll( List<? extends WorkItem> workItems, long timeout )
        throws WorkException
    {
        // each work item is run at schedule time
        return true;
    }

    public boolean waitForAll( List<? extends WorkItem> workItems )
    {
        // each work item is run at schedule time
        return true;
    }

}
