

package gov.va.med.cds.template;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.request.ValidationException;

import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class TemplateWriteRequestTest
{

    private static TemplateWriteRequest templateWriteRequest = null;


    @BeforeClass
    @Suite( groups = { "checkintest" } )
    public static void templateWriteRequestTestSetUp( )
    {
        templateWriteRequest = new TemplateWriteRequest( "aXmlRequest" );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void requestIdTest( )
    {
        templateWriteRequest.setRequestId( "aRequestId" );
        assertEquals( "aRequestId", templateWriteRequest.getRequestId() );
    }


    @Test( expected = ValidationException.class )
    @Suite( groups = { "checkintest" } )
    public void requestIdNullTest( )
    {
        templateWriteRequest.setRequestId( null );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void templateIdTest( )
    {
        templateWriteRequest.setTemplateId( "aTemplateId" );
        assertEquals( "aTemplateId", templateWriteRequest.getTemplateId() );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void requestDataTest( )
    {
        templateWriteRequest.setRequestData( "requestData" );
        assertEquals( "requestData", templateWriteRequest.getRequestData() );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void operationTest( )
    {
        templateWriteRequest.setOperation( Operation.Read );
        assertEquals( Operation.Read, templateWriteRequest.getOperation() );
    }

}
