

package gov.va.med.cds.response.sequencer;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.template.AbstractTemplateManagerTest;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.xml.XmlComparator;
import gov.va.med.cds.testharness.xml.XmlCompareException;

import org.dom4j.Document;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
public class ResponseNonSequenceSchemaSequencerTest
    extends
        AbstractTemplateManagerTest
{
    private static boolean validateReadResponseXml = true;


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_ClinicalDocumentEvent40011( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>TiuDocumentListRead2</templateId> <requestId>36186097-8C3F-AEA1-EF54-5C9C4B327905</requestId> <patients> <patient> <requestedResolvedIdentifiers> <requestedResolvedIdentifier> <identity>1</identity> <assigningFacility>521</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifier> </requestedResolvedIdentifiers> <clinicalDocumentEvents> <clinicalDocumentEvent> <recordIdentifier> <identity>6.0</identity> <namespaceId>580</namespaceId> </recordIdentifier> <patient> <identifier> <identity>1.0</identity> </identifier> <name> <given>PATIENT</given> <family>ZZZRETFIVEFIFTYONE</family> </name> </patient> <referenceDate> <literal>19900713150000</literal> </referenceDate> <standardizedDocumentTitle> <codingSystem>580</codingSystem> </standardizedDocumentTitle> <localDocumentTitle>INTERIM PROGRESS NOTE</localDocumentTitle> <statusCode> <code>4501014</code> <displayText>7.0</displayText> </statusCode> <authorDictator> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </authorDictator> <expectedSigner> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </expectedSigner> <signer> <practitioner> <identifier> <identity>33.0</identity> </identifier> <name> <given>ONE</given> <family>PROVIDER</family> </name> </practitioner> <signatureBlockName>1@xj;kg-+_}</signatureBlockName> <signatureMode> <displayText>E</displayText> </signatureMode> </signer> <enteredDate> <literal>19930413092757</literal> </enteredDate> <procedureSummaryCode> <codingSystem>99VA8985.1</codingSystem> </procedureSummaryCode> <treatingSpecialtyCode> <codingSystem>580</codingSystem> </treatingSpecialtyCode> <serviceCode> <codingSystem>580</codingSystem> </serviceCode> <treatmentEpisode> <treatmentBeginDate> <literal>19900713150000</literal> </treatmentBeginDate> </treatmentEpisode> <tiuPatientVisit> <assignedLocation> <facilityNamespaceId>515.8</facilityNamespaceId> <facilityUniversalId>FT. LOGAN</facilityUniversalId> </assignedLocation> <visitAdmitDate> <literal>1990-07-13 15:00:00</literal> </visitAdmitDate> </tiuPatientVisit> <urgency> <codingSystem>99VA8985.1</codingSystem> </urgency> </clinicalDocumentEvent> </clinicalDocumentEvents> </patient> </patients> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>TiuDocumentListRead2</templateId> <requestId>36186097-8C3F-AEA1-EF54-5C9C4B327905</requestId> <patients> <patient> <requestedResolvedIdentifiers> <requestedResolvedIdentifier> <identity>1</identity> <assigningFacility>521</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifier> </requestedResolvedIdentifiers> <clinicalDocumentEvents> <clinicalDocumentEvent> <recordIdentifier> <identity>6.0</identity> <namespaceId>580</namespaceId> </recordIdentifier> <patient> <identifier> <identity>1.0</identity> </identifier> <name> <given>PATIENT</given> <family>ZZZRETFIVEFIFTYONE</family> </name> </patient> <standardizedDocumentTitle> <codingSystem>580</codingSystem> </standardizedDocumentTitle> <referenceDate> <literal>19900713150000</literal> </referenceDate> <localDocumentTitle>INTERIM PROGRESS NOTE</localDocumentTitle> <statusCode> <code>4501014</code> <displayText>7.0</displayText> </statusCode> <authorDictator> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </authorDictator> <expectedSigner> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </expectedSigner> <signer> <practitioner> <identifier> <identity>33.0</identity> </identifier> <name> <given>ONE</given> <family>PROVIDER</family> </name> </practitioner> <signatureBlockName>1@xj;kg-+_}</signatureBlockName> <signatureMode> <displayText>E</displayText> </signatureMode> </signer> <enteredDate> <literal>19930413092757</literal> </enteredDate> <procedureSummaryCode> <codingSystem>99VA8985.1</codingSystem> </procedureSummaryCode> <treatingSpecialtyCode> <codingSystem>580</codingSystem> </treatingSpecialtyCode> <serviceCode> <codingSystem>580</codingSystem> </serviceCode> <treatmentEpisode> <treatmentBeginDate> <literal>19900713150000</literal> </treatmentBeginDate> </treatmentEpisode> <tiuPatientVisit> <assignedLocation> <facilityNamespaceId>515.8</facilityNamespaceId> <facilityUniversalId>FT. LOGAN</facilityUniversalId> </assignedLocation> <visitAdmitDate> <literal>1990-07-13 15:00:00</literal> </visitAdmitDate> </tiuPatientVisit> <urgency> <codingSystem>99VA8985.1</codingSystem> </urgency> </clinicalDocumentEvent> </clinicalDocumentEvents> </patient> </patients></clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.TIU_DOCUMENT_LIST_READ;
        NonSequenceResponseSchemaSequencer sequencer = new NonSequenceResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testUnsequenced_ClinicalDocumentEvent40012( )
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>TiuDocumentDetailRead40012</templateId> <requestId>A926B9BA-1873-512B-6842-0A9BC039F820</requestId> <patients> <patient> <requestedResolvedIdentifiers> <requestedResolvedIdentifier> <identity>1</identity> <assigningFacility>521</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifier> </requestedResolvedIdentifiers> <clinicalDocumentEvents> <clinicalDocumentEvent> <recordIdentifier> <identity>6.0</identity> <namespaceId>580</namespaceId> </recordIdentifier> <patient> <identifier> <identity>1.0</identity> </identifier> <name> <given>PATIENT</given> <family>ZZZRETFIVEFIFTYONE</family> </name> </patient> <referenceDate> <literal>19900713150000</literal> </referenceDate> <standardizedDocumentTitle> <codingSystem>580</codingSystem> </standardizedDocumentTitle> <localDocumentTitle>INTERIM PROGRESS NOTE</localDocumentTitle> <documentTexts> <documentText>This is a test of the YS*4.18*2 PATCH.</documentText> <documentText>Testing to see if the date note written is wrong prior to patch install.</documentText> </documentTexts> <statusCode> <code>4501014</code> <displayText>7.0</displayText> </statusCode> <authorDictator> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </authorDictator> <signer> <practitioner> <identifier> <identity>33.0</identity> </identifier> <name> <given>ONE</given> <family>PROVIDER</family> </name> </practitioner> <signatureBlockName>1@xj;kg-+_}</signatureBlockName> <signatureMode> <displayText>E</displayText> </signatureMode> </signer> <enteredDate> <literal>19930413092757</literal> </enteredDate> <procedureSummaryCode> <codingSystem>99VA8985.1</codingSystem> </procedureSummaryCode> <treatingSpecialtyCode> <codingSystem>580</codingSystem> </treatingSpecialtyCode> <serviceCode> <codingSystem>580</codingSystem> </serviceCode> <urgency> <codingSystem>99VA8985.1</codingSystem> </urgency> <otherCosigners/> <tiuPatientVisit> <assignedLocation> <facilityNamespaceId>515.8</facilityNamespaceId> <facilityUniversalId>FT. LOGAN</facilityUniversalId> </assignedLocation> <visitAdmitDate/> </tiuPatientVisit> <treatmentEpisode> <treatmentBeginDate> <literal>19900713150000</literal> </treatmentBeginDate> </treatmentEpisode> <printName>TODO: Need VistA Mapping</printName> </clinicalDocumentEvent> </clinicalDocumentEvents> </patient> </patients> </clinicaldata:ClinicalData>";
        String unsequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>TiuDocumentDetailRead40012</templateId> <requestId>A926B9BA-1873-512B-6842-0A9BC039F820</requestId> <patients> <patient> <requestedResolvedIdentifiers> <requestedResolvedIdentifier> <identity>1</identity> <assigningFacility>521</assigningFacility> <assigningAuthority>USVHA</assigningAuthority> </requestedResolvedIdentifier> </requestedResolvedIdentifiers> <clinicalDocumentEvents> <clinicalDocumentEvent> <recordIdentifier> <identity>6.0</identity> <namespaceId>580</namespaceId> </recordIdentifier> <patient> <identifier> <identity>1.0</identity> </identifier> <name> <given>PATIENT</given> <family>ZZZRETFIVEFIFTYONE</family> </name> </patient> <referenceDate> <literal>19900713150000</literal> </referenceDate> <localDocumentTitle>INTERIM PROGRESS NOTE</localDocumentTitle> <standardizedDocumentTitle> <codingSystem>580</codingSystem> </standardizedDocumentTitle> <documentTexts> <documentText>This is a test of the YS*4.18*2 PATCH.</documentText> <documentText>Testing to see if the date note written is wrong prior to patch install.</documentText> </documentTexts> <statusCode> <code>4501014</code> <displayText>7.0</displayText> </statusCode> <authorDictator> <identifier> <identity>9.0</identity> </identifier> <name> <given>SEVEN</given> <family>PROGRAMMER</family> </name> </authorDictator> <signer> <practitioner> <identifier> <identity>33.0</identity> </identifier> <name> <given>ONE</given> <family>PROVIDER</family> </name> </practitioner> <signatureBlockName>1@xj;kg-+_}</signatureBlockName> <signatureMode> <displayText>E</displayText> </signatureMode> </signer> <enteredDate> <literal>19930413092757</literal> </enteredDate> <procedureSummaryCode> <codingSystem>99VA8985.1</codingSystem> </procedureSummaryCode> <treatingSpecialtyCode> <codingSystem>580</codingSystem> </treatingSpecialtyCode> <serviceCode> <codingSystem>580</codingSystem> </serviceCode> <urgency> <codingSystem>99VA8985.1</codingSystem> </urgency> <otherCosigners/> <tiuPatientVisit> <assignedLocation> <facilityNamespaceId>515.8</facilityNamespaceId> <facilityUniversalId>FT. LOGAN</facilityUniversalId> </assignedLocation> <visitAdmitDate/> </tiuPatientVisit> <treatmentEpisode> <treatmentBeginDate> <literal>19900713150000</literal> </treatmentBeginDate> </treatmentEpisode> <printName>TODO: Need VistA Mapping</printName> </clinicalDocumentEvent> </clinicalDocumentEvents> </patient> </patients> </clinicaldata:ClinicalData>";
        String templateId = TemplateIdHelper.TIU_DOCUMENT_DETAIL_READ;
        NonSequenceResponseSchemaSequencer sequencer = new NonSequenceResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );
        Document resultDoc = sequencer.sequence( templateId, unsequencedXml, validateReadResponseXml );
        assertNotNull( resultDoc );

        try
        {
            XmlComparator.assertXMLSimilar( sequencedXml, resultDoc.asXML() );
        }
        catch ( XmlCompareException xce )
        {
            fail();
        }

    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEmptySourceDocument( )
    {
        String templateId = TemplateIdHelper.TIU_DOCUMENT_LIST_READ;
        NonSequenceResponseSchemaSequencer sequencer = new NonSequenceResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, "", validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "SCHEMA_VALIDATION_FAILED" ) );
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testInvalidSourceDocument( )
    {
        String templateId = TemplateIdHelper.TIU_DOCUMENT_LIST_READ;
        NonSequenceResponseSchemaSequencer sequencer = new NonSequenceResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, "<clinicaldata:ClinicalData xmlns:clinicaldata='Clinicaldata'></clinicaldata:ClinicalData>",
                            validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "SCHEMA_VALIDATION_FAILED" ) );
        }
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testInvalidSchema( )
        throws Exception
    {
        String sequencedXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"> <templateId>IntoleranceConditionRead40010</templateId> <requestId>CDCD4F33-0D91-107D-DA17-4959A1DE24A8</requestId> <patient> <requestedResolvedIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </requestedResolvedIdentifiers> <resultantIdentifiers> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </resultantIdentifiers> <intoleranceConditions> <recordIdentifier> <identity>FNTest_Intolerance_Condition_identity</identity> <namespaceId>DefaultAssigningFacility</namespaceId> <universalId>1204757305879100021</universalId> <universalIdType>aUniversalIdType</universalIdType> </recordIdentifier> <patient> <identifier> <identity>talbotTest</identity> <assigningFacility>intoleranceConditionTest</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </patient> <observationTime> <literal>19691231170000</literal> </observationTime> <agent> <code>Other3</code> <displayText>AgentDisplayTextLite</displayText> <codingSystem>AgentCodingSystemLite</codingSystem> </agent> <allergyType> <code>Other</code> <displayText>AllergyTypeDisplayTextLite</displayText> <codingSystem>AllergyTypeCodingSystemLite</codingSystem> </allergyType> <gmrAllergyAgent> <code>Other3</code> <displayText>AgentDisplayText</displayText> <codingSystem>AgentCodingSystem</codingSystem> <alternateCode>Agenttest_altcode_3004</alternateCode> <alternateDisplayText>AgentAltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>AgentAltCodingSystem</alternateCodingSystem> </gmrAllergyAgent> <informationSourceCategory> <code>test_code_2003</code> <displayText>ISC DisplayTextLite</displayText> <codingSystem>ISC CodingSystemLite</codingSystem> </informationSourceCategory> <mechanism> <code>test_code_2005</code> <displayText>Mechanism DisplayTextLite</displayText> <codingSystem>Mechanism CodingSystemLite</codingSystem> </mechanism> <status>Status</status> <verified>true</verified> <reaction> <observationTime> <literal>19691231170000</literal> </observationTime> <reaction> <code>test_code_2002</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <reaction> <observationTime> <literal>19691231170000</literal> </observationTime> <reaction> <code>test_code_2003</code> <displayText>Reaction DisplayTextLite</displayText> <codingSystem>Reaction CodingSystemLite</codingSystem> </reaction> <author> <comment>Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_eid_1002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> </reaction> <verifier> <comment>Verifier Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_VERIFIERID_2002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </verifier> <author> <comment>Author Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_AUTHORID_1003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </author> <errorEnterer> <comment>ErrorEnterer Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_ERRORENTERERID_5004</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </errorEnterer> <idBandMarker> <comment>ID Band Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <idBandMarker> <comment>ID Band Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_IDBANDUPDATERID_3002</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </idBandMarker> <chartMarker> <comment>Chart Marker 2 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4001</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <chartMarker> <comment>Chart Marker 1 Comment</comment> <time> <literal>20080305154825</literal> </time> <practitioner> <identifier> <identity>test_CHARTMARKERID_4003</identity> <assigningFacility>DefaultAssigningFacility</assigningFacility> <assigningAuthority>DefaultAssigningAuthority</assigningAuthority> </identifier> <idSourceTable>IdSourceTable</idSourceTable> <name> <prefix>Prefix</prefix> <given>Given</given> <middle>MiddleName</middle> <family>FamilyName</family> <suffix>Suffix</suffix> <title>Title</title> </name> </practitioner> </chartMarker> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <commentEvents> <date> <literal>String</literal> </date> <author> <identifier> <identity>String</identity> <assigningFacility>String</assigningFacility> <assigningAuthority>String</assigningAuthority> </identifier> <idSourceTable>String</idSourceTable> <name> <prefix>String</prefix> <given>String</given> <middle>String</middle> <family>String</family> <suffix>String</suffix> <title>String</title> </name> </author> <commentType> <code>String</code> <displayText>String</displayText> <codingSystem>String</codingSystem> </commentType> <comments>String</comments> <comments>String</comments> </commentEvents> <drugClass> <code> <code>Class6</code> <displayText>Drug Class 2DisplayText</displayText> <codingSystem>Drug Class 2CodingSystem</codingSystem> <alternateCode>Drug Class 2test_altcode_3005</alternateCode> <alternateDisplayText>Drug Class 2AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 2AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugClass> <code> <code>Class4</code> <displayText>Drug Class 1DisplayText</displayText> <codingSystem>Drug Class 1CodingSystem</codingSystem> <alternateCode>Drug Class 1test_altcode_3001</alternateCode> <alternateDisplayText>Drug Class 1AltDisplayTextLite</alternateDisplayText> <alternateCodingSystem>Drug Class 1AltCodingSystem</alternateCodingSystem> </code> </drugClass> <drugIngredient> <code> <code>Ingredient3</code> <displayText>Drug Ing. 2DisplayTextLite</displayText> <codingSystem>Drug Ing. 2CodingSystemLite</codingSystem> </code> </drugIngredient> <drugIngredient> <code> <code>Ingredient6</code> <displayText>Drug Ing. 1DisplayTextLite</displayText> <codingSystem>Drug Ing. 1CodingSystemLite</codingSystem> </code> </drugIngredient> <facilityIdentifier> <identity>OrganizationId</identity> <name>OrganizationName</name> <assigningAuthority>AssigningAuthNamespaceId</assigningAuthority> </facilityIdentifier> <recordVersion>10002</recordVersion> <recordUpdateTime> <literal>20080305154825</literal> </recordUpdateTime> </intoleranceConditions> </patient> </clinicaldata:ClinicalData>";
        String templateId = "invalid_template";
        NonSequenceResponseSchemaSequencer sequencer = new NonSequenceResponseSchemaSequencer();
        sequencer.setTemplateManager( getTemplateManager() );

        try
        {
            sequencer.sequence( templateId, sequencedXml, validateReadResponseXml );
        }
        catch ( Exception ex )
        {
            assertTrue( ex.getMessage().contains( "SCHEMA_VALIDATION_FAILED" ) );
        }

    }
}
