

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.junit.runners.Suite;

import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.junit.Assert;
import org.junit.Test;


public class VistaMHVLabChemHemRead1TestsUserTypeTest
{
    private static final String fromDb = "183*122^L^82466.0000!1.0!1.0!1.0!!!1.0^10958^72!135!288!!!!mg/dL!^^^^500,205*32^L^81132.0000!^10958^72!36!165!!!!mg/dL!^^^^500,244*12^L^81132.0000!^10958^72!32!72!!!!MG/DL!^^^^500,901*33^^81132.0000!^10958^72!!!!!!MG/DL!^^^^500,";
    static VistaPersonName vistaPersonName = new VistaPersonName( fromDb );

    private static final int NO_OF_COLUMNS = 8;
    private static String[] PROPERTY_NAMES = new String[NO_OF_COLUMNS];
    private static Type[] PROPERTY_TYPES = new Type[NO_OF_COLUMNS];
    private VistaMHVLabChemHemRead1TestsUserType userType = new VistaMHVLabChemHemRead1TestsUserType();

    static
    {
        for ( int column = 0; column < NO_OF_COLUMNS; column++ )
        {
            PROPERTY_NAMES[column] = "";
            PROPERTY_TYPES[column] = StandardBasicTypes.STRING;
        }
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testNullSafeSet( )
        throws Exception
    {
        userType.nullSafeSet( null, null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsMutable( )
    {
        Assert.assertFalse( userType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        Assert.assertEquals( vistaPersonName, userType.replace( vistaPersonName, null, null, null ) );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testSetPropertyValue( )
        throws Exception
    {
        userType.setPropertyValue( null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testAssemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.assemble( vistaPersonName, null, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDeepCopy( )
    {
        Assert.assertEquals( vistaPersonName, userType.deepCopy( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisassemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.disassemble( vistaPersonName, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNotEqualsObjectObject( )
    {
        VistaPersonName vistaPersonName1 = new VistaPersonName( "^^^^^^^" );
        Assert.assertFalse( userType.equals( vistaPersonName, vistaPersonName1 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsObjectObject( )
    {
        Assert.assertFalse( userType.equals( null, vistaPersonName ) );
        Assert.assertTrue( userType.equals( vistaPersonName, vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyNames( )
    {
        Assert.assertEquals( PROPERTY_NAMES.length, userType.getPropertyNames().length );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyTypes( )
    {
        userType.getPropertyTypes();
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testGetPropertyValue( )
        throws Exception
    {
        userType.getPropertyValue( null, 1 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeObject( )
    {
        Assert.assertNotSame( 0, userType.hashCode( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeOfNull( )
    {
        Assert.assertEquals( 0, userType.hashCode( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReturnedClass( )
    {
        Assert.assertEquals( java.lang.String.class, userType.returnedClass() );
    }

}
