

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.template.generated.vitalsigns.OxygenAdministration;

import org.dom4j.Element;
import org.easymock.EasyMock;
import org.hibernate.EntityMode;
import org.hibernate.engine.spi.SessionImplementor;
import org.junit.Assert;
import org.junit.Test;

import java.sql.ResultSet;


public class VWSupplementalOxygenUserTypeTest
{
    private static final String fromDb = "10.5 l/min^%SpO2";
    static SupplementalOxygen vistaPersonName = new SupplementalOxygen( fromDb );

    private static String[] PROPERTY_NAMES = {""};
    private VWSupplementalOxygenUserType userType = new VWSupplementalOxygenUserType();


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( "10.5 l/min^%SpO2" ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
       

        EasyMock.replay( resultSet, sessionImplementor );

        OxygenAdministration ox02 = (OxygenAdministration) userType.nullSafeGet( resultSet, names, sessionImplementor, null );
        String expectedOs = "10.5";
        Assert.assertEquals( expectedOs, ox02.getFlowRateValue());
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet2( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( "10.5^%SpO2" ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
        

        EasyMock.replay( resultSet, sessionImplementor );

        OxygenAdministration ox02 = (OxygenAdministration) userType.nullSafeGet( resultSet, names, sessionImplementor, null );
        String expectedOs = "10.5";
        Assert.assertEquals( expectedOs, ox02.getConcentrationValue());
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGet3( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( "10.5 l/min 1^%SpO2" ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
        

        EasyMock.replay( resultSet, sessionImplementor );

        OxygenAdministration ox02 = (OxygenAdministration) userType.nullSafeGet( resultSet, names, sessionImplementor, null );
        String expectedOs = "l/min";
        Assert.assertEquals( expectedOs, ox02.getFlowRateUnit().getDisplayText());
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNullSafeGetWithNullResultSet( )
        throws Exception
    {
        ResultSet resultSet = EasyMock.createMock( ResultSet.class );
        String[] names = { "person" };
        EasyMock.expect( resultSet.getString( names[0] ) ).andReturn( null ).anyTimes();

        SessionImplementor sessionImplementor = EasyMock.createMock( SessionImplementor.class );
       
        EasyMock.replay( resultSet, sessionImplementor );

        Assert.assertNull( userType.nullSafeGet( resultSet, names, sessionImplementor, null ) );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testNullSafeSet( )
        throws Exception
    {
        userType.nullSafeSet( null, null, 1, null );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testIsMutable( )
    {
        Assert.assertFalse( userType.isMutable() );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReplace( )
    {
        Assert.assertEquals( vistaPersonName, userType.replace( vistaPersonName, null, null, null ) );
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testSetPropertyValue( )
        throws Exception
    {
        userType.setPropertyValue( null, 1, null );
    }


    @Test
    public void testAssemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.assemble( vistaPersonName, null, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDeepCopy( )
    {
        Assert.assertEquals( vistaPersonName, userType.deepCopy( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testDisassemble( )
    {
        Assert.assertEquals( vistaPersonName, userType.disassemble( vistaPersonName, null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testNotEqualsObjectObject( )
    {
        VistaPersonName vistaPersonName1 = new VistaPersonName( "^^^^^^^" );
        Assert.assertFalse( userType.equals( vistaPersonName, vistaPersonName1 ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testEqualsObjectObject( )
    {
        Assert.assertFalse( userType.equals( null, vistaPersonName ) );
        Assert.assertTrue( userType.equals( vistaPersonName, vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyNames( )
    {
        Assert.assertEquals( PROPERTY_NAMES.length, userType.getPropertyNames().length );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testGetPropertyTypes( )
    {
        userType.getPropertyTypes();
    }


    @Test( expected = UnsupportedOperationException.class )
    @Suite( groups = "checkintest" )
    public void testGetPropertyValue( )
        throws Exception
    {
        userType.getPropertyValue( null, 1 );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeObject( )
    {
        Assert.assertNotSame( 0, userType.hashCode( vistaPersonName ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testHashCodeOfNull( )
    {
        Assert.assertEquals( 0, userType.hashCode( null ) );
    }


    @Test
    @Suite( groups = "checkintest" )
    public void testReturnedClass( )
    {
        Assert.assertEquals( VWSupplementalOxygenUserType.class, userType.returnedClass() );
    }

}
