package gov.va.med.cds.persistence.hibernate;


import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.filter.ParameterMapInterface;
import gov.va.med.cds.filter.QueryParameter;
import gov.va.med.cds.persistence.QueryAssociationInterface;
import gov.va.med.cds.persistence.hibernate.rpc.RpcParamStringBuilderInterface;
import gov.va.med.cds.response.strategy.VistaGenericStoredProcedureResponseStrategyInterface;
import gov.va.med.cds.response.strategy.VistaGenericStoredProcedureSingleResponseStrategyInterface;

import org.easymock.EasyMock;
import org.hibernate.Session;
import org.junit.Test;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import junit.framework.Assert;


public class VistaGenericStoredProcedureQueryWorkTest
{
	private Session session;

	private QueryAssociationInterface queryAssociation;

	private EntryFilterInterface entryFilter;

	private List<String> personIdentifiers;

	private Map<String, QueryParameterTransformerInterface> parameterTransformerMap;

	private Map<String, String> queryMap;

	private VistaGenericStoredProcedureSingleResponseStrategyInterface vistaResponseStrategy;

	private static final String APP_NAME = "CDS";

	private static final String SITE_ID = "555";

	private static final String USER_NAME = "HDR";
	private static final String KEY = "hzP09oLP20O2KcBR";
	private static final String PASSWORD = "ak146CEukIg93Y3KqeHMbXxQFK6lorCAK1uOcNeYdUQ6IAA7KebqYW8BYSuwiWIQ";

	private static final String RPC_NAME = "RPC|Run|VPR GET PATIENT DATA JSON";

	private RpcParamStringBuilderInterface rpcBuilder;


	@Test
	public void testBuildQueryString()
	{
		queryAssociation = EasyMock.createMock(QueryAssociationInterface.class);
		entryFilter = EasyMock.createMock(EntryFilterInterface.class);
		personIdentifiers = EasyMock.createMock(List.class);
		queryMap = EasyMock.createMock(Map.class);
		rpcBuilder = EasyMock.createMock(RpcParamStringBuilderInterface.class);

		VistaGenericStoredProcedureQueryWork queryWork = new VistaGenericStoredProcedureQueryWork(
				session, queryAssociation, entryFilter, personIdentifiers,
				parameterTransformerMap, queryMap, vistaResponseStrategy,
				APP_NAME, SITE_ID, USER_NAME, PASSWORD, KEY.getBytes(), rpcBuilder);

		EasyMock.expect(queryAssociation.getAssociationName()).andReturn("GenericObservation");
		EasyMock.expect(queryMap.get("GenericObservationRead1.GSP")).andReturn("SOME VALUE");

		EasyMock.replay(queryAssociation, entryFilter, personIdentifiers, queryMap);

		String response = queryWork.buildQueryString(queryAssociation.getAssociationName(), entryFilter, personIdentifiers);

		EasyMock.verify(queryAssociation, entryFilter, personIdentifiers, queryMap);

		Assert.assertNotNull(response);
		Assert.assertEquals("SOME VALUE", response);
	}

	//@Test
	public void testBuildQueryParameterListBasic()
	{
		queryAssociation = EasyMock.createMock(QueryAssociationInterface.class);
		entryFilter = EasyMock.createMock(EntryFilterInterface.class);
		parameterTransformerMap = EasyMock.createMock(Map.class);
		personIdentifiers = EasyMock.createMock(List.class);
		QueryParameterTransformerInterface pidsTransformer = EasyMock.createMock(QueryParameterTransformerInterface.class);
		QueryParameterTransformerInterface dateTransformer = EasyMock.createMock(QueryParameterTransformerInterface.class);
		ParameterMapInterface parameterMap = EasyMock.createMock(ParameterMapInterface.class);
		rpcBuilder = EasyMock.createMock(RpcParamStringBuilderInterface.class);

		VistaGenericStoredProcedureQueryWork queryWork = new VistaGenericStoredProcedureQueryWork(session, queryAssociation, entryFilter, personIdentifiers,
				parameterTransformerMap, queryMap, vistaResponseStrategy,
				APP_NAME, SITE_ID, USER_NAME, PASSWORD, KEY.getBytes(), rpcBuilder);

		EasyMock.expect(queryAssociation.getAssociationName()).andReturn("GenericObservation");
		EasyMock.expect(parameterTransformerMap.get("pids")).andReturn(pidsTransformer);
		EasyMock.expect(pidsTransformer.transform(personIdentifiers)).andReturn(personIdentifiers);
		EasyMock.expect(personIdentifiers.get(0)).andReturn("12345");
		EasyMock.expect(entryFilter.getStartDate()).andReturn(null);
		EasyMock.expect(parameterTransformerMap.get("startDate")).andReturn(dateTransformer);
		EasyMock.expect(entryFilter.getEndDate()).andReturn(null);
		EasyMock.expect(parameterTransformerMap.get("startDate")).andReturn(dateTransformer);
		EasyMock.expect(entryFilter.getDomainEntryPoint()).andReturn("PROBLEM").anyTimes();
		EasyMock.expect(entryFilter.getRecordIdentifiers()).andReturn(null);
		EasyMock.expect(entryFilter.getAdditionalParametersMap()).andReturn(parameterMap);
		EasyMock.expect(parameterMap.getFilterParameterNames()).andReturn(new HashSet<String>());

		EasyMock.replay(queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, pidsTransformer, dateTransformer,	parameterMap);

		List<String> queryParams = queryWork.buildQueryParameterList("SOME VALUE", queryAssociation.getAssociationName(), entryFilter, personIdentifiers);

		EasyMock.verify(queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, pidsTransformer, dateTransformer, parameterMap);

		Assert.assertTrue(queryParams.size() == 4);
		Assert.assertEquals(USER_NAME, queryParams.get(0));
	}


	//@Test
	public void testBuildQueryParameterListExtended()
	{
		queryAssociation = EasyMock.createMock(QueryAssociationInterface.class);
		entryFilter = EasyMock.createMock(EntryFilterInterface.class);
		parameterTransformerMap = EasyMock.createMock(Map.class);
		personIdentifiers = EasyMock.createMock(List.class);
		QueryParameterTransformerInterface pidsTransformer = EasyMock.createMock(QueryParameterTransformerInterface.class);
		QueryParameterTransformerInterface dateTransformer = EasyMock.createMock(QueryParameterTransformerInterface.class);
		ParameterMapInterface parameterMap = EasyMock.createMock(ParameterMapInterface.class);
		rpcBuilder = EasyMock.createMock(RpcParamStringBuilderInterface.class);
		QueryParameter maxQueryParameter = new QueryParameter<String>();
		maxQueryParameter.setName("max");
		maxQueryParameter.setType("text");
		maxQueryParameter.setValue("1");

		Set<String> filterParameterNames = new HashSet<String>();
		filterParameterNames.add("max");

		VistaGenericStoredProcedureQueryWork queryWork = new VistaGenericStoredProcedureQueryWork(session, queryAssociation, entryFilter, personIdentifiers,
				parameterTransformerMap, queryMap, vistaResponseStrategy,
				APP_NAME, SITE_ID, USER_NAME, PASSWORD, KEY.getBytes(), rpcBuilder);

		EasyMock.expect(queryAssociation.getAssociationName()).andReturn("GenericObservation");
		EasyMock.expect(parameterTransformerMap.get("pids")).andReturn(pidsTransformer);
		EasyMock.expect(pidsTransformer.transform(personIdentifiers)).andReturn(personIdentifiers);
		EasyMock.expect(personIdentifiers.get(0)).andReturn("12345");
		EasyMock.expect(entryFilter.getStartDate()).andReturn(null);
		EasyMock.expect(parameterTransformerMap.get("startDate")).andReturn(dateTransformer);
		EasyMock.expect(entryFilter.getEndDate()).andReturn(null);
		EasyMock.expect(parameterTransformerMap.get("startDate")).andReturn(dateTransformer);
		EasyMock.expect(entryFilter.getDomainEntryPoint()).andReturn("PROBLEM").anyTimes();
		EasyMock.expect(entryFilter.getRecordIdentifiers()).andReturn(null);
		EasyMock.expect(entryFilter.getAdditionalParametersMap()).andReturn(parameterMap);
		EasyMock.expect(parameterMap.getFilterParameterNames()).andReturn(filterParameterNames);
		EasyMock.expect(parameterMap.getParameterValue("max")).andReturn((maxQueryParameter));

		EasyMock.replay(queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, pidsTransformer, dateTransformer, parameterMap);

		List<String> queryParams = queryWork.buildQueryParameterList("SOME VALUE", queryAssociation.getAssociationName(), entryFilter, personIdentifiers);

		EasyMock.verify(queryAssociation, entryFilter, personIdentifiers, parameterTransformerMap, pidsTransformer, dateTransformer, parameterMap);

		Assert.assertTrue(queryParams.size() == 4);
		Assert.assertEquals(USER_NAME, queryParams.get(0));
	}
}
