package gov.va.med.cds.persistence.hibernate;

import static org.junit.Assert.*;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TimestampQueryParameterTransformerTest
{

    @Before
    public void setUp( )
        throws Exception
    {
    }


    @After
    public void tearDown( )
        throws Exception
    {
    }


    @Test
    public void testTransformAndSetParameter( )
    {
        Calendar calendar = Calendar.getInstance();
        Map<String, Object> parameterMap = new HashMap<String, Object>();
        
        TimestampQueryParameterTransformer transformer = new TimestampQueryParameterTransformer();
        transformer.transformAndSetParameter( "dateTime", calendar, parameterMap );
        
        assertTrue(parameterMap.get("dateTime") != null);
        assertTrue(parameterMap.get("dateTime") instanceof Timestamp);
    }
    
    
    @Test(expected=IllegalArgumentException.class)
    public void testTransformAndSetParameterIllegalArgument( )
    {
        Date calendar = new Date();
        Map<String, Object> parameterMap = new HashMap<String, Object>();
        
        TimestampQueryParameterTransformer transformer = new TimestampQueryParameterTransformer();
        transformer.transformAndSetParameter( "dateTime", calendar, parameterMap );
    }

}
