

package gov.va.med.cds.persistence;


import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class PersistenceLocatorTest
{
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testGetWritablePersistenceManager( )
    {
        PersistenceLocator persistenceLocator = new PersistenceLocator();
        
        WritePersistenceManagerInterface wpm = EasyMock.createMock( WritePersistenceManagerInterface.class );
        EasyMock.expect( wpm.isApplicable( DomainEntryPoint.AllergyAssessment ) ).andReturn(Boolean.TRUE);
        WritePersistenceManagerInterface wpm2 = EasyMock.createMock( WritePersistenceManagerInterface.class ); 
        EasyMock.expect( wpm2.isApplicable( DomainEntryPoint.AllergyAssessment ) ).andReturn(Boolean.FALSE);
        EasyMock.replay( wpm, wpm2 );
        
        List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        persistenceManagers.add( wpm );
        persistenceManagers.add( wpm2 );
        
        persistenceLocator.setDynamicPersistenceManagers( persistenceManagers );
        WritePersistenceManagerInterface writeable = persistenceLocator.getWritePersistenceManager( DomainEntryPoint.AllergyAssessment );
        
        assertNotNull( writeable );
        assertEquals( writeable, wpm );
    }
    

    @Test ( expected = PersistenceException.class )
    @Suite( groups = { "checkintest" } )
    public void testGetWritablePersistenceManagerNull( )
    {
        PersistenceLocator persistenceLocator = new PersistenceLocator();
        WritePersistenceManagerInterface wpm = EasyMock.createMock( WritePersistenceManagerInterface.class );
        EasyMock.expect( wpm.isApplicable( DomainEntryPoint.AllergyAssessment ) ).andReturn(Boolean.FALSE);
        WritePersistenceManagerInterface wpm2 = EasyMock.createMock( WritePersistenceManagerInterface.class );
        EasyMock.expect( wpm2.isApplicable( DomainEntryPoint.AllergyAssessment ) ).andReturn(Boolean.FALSE);
        EasyMock.replay( wpm, wpm2 );
        
        List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        persistenceManagers.add( wpm );
        persistenceManagers.add( wpm2 );
        
        persistenceLocator.setDynamicPersistenceManagers( persistenceManagers );
        
        persistenceLocator.getWritePersistenceManager( DomainEntryPoint.AllergyAssessment );
        Assert.fail( "Previous method call should have resulted in an error." );

    }
    
    
    @Test ( expected = PersistenceException.class )
    @Suite( groups = { "checkintest" } )
    public void testGetWritablePersistenceManagerStaticNull( )
    {
        PersistenceLocator persistenceLocator = new PersistenceLocator();
        WritePersistenceManagerInterface wpm = EasyMock.createMock( WritePersistenceManagerInterface.class );
        EasyMock.expect( wpm.isApplicable( DomainEntryPoint.PatientEnteredVitalSign ) ).andReturn(Boolean.FALSE);
        WritePersistenceManagerInterface wpm2 = EasyMock.createMock( WritePersistenceManagerInterface.class );
        EasyMock.expect( wpm2.isApplicable( DomainEntryPoint.PatientEnteredVitalSign ) ).andReturn(Boolean.FALSE);
        EasyMock.replay( wpm, wpm2 );
        
        List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        persistenceManagers.add( wpm );
        persistenceManagers.add( wpm2 );
        
        persistenceLocator.setStaticPersistenceManagers( persistenceManagers );
        
        persistenceLocator.getWritePersistenceManager( DomainEntryPoint.PatientEnteredVitalSign );
        Assert.fail( "Previous method call should have resulted in an error." );
    }


    @Test
    @Suite( groups = { "slowtest" } )
    public void testGetReadablePersistenceManagerMultiple( )
    {
        PersistenceLocator persistenceLocator = new PersistenceLocator();
        List<PersonIdentifierInterface> personIdentifiers = new ArrayList<PersonIdentifierInterface>();
        
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );
        ReadPersistenceManagerInterface rpm1 = EasyMock.createMock( ReadPersistenceManagerInterface.class );
        ReadPersistenceManagerInterface rpm2 = EasyMock.createMock( ReadPersistenceManagerInterface.class );
        WritePersistenceManagerInterface wpm1 = EasyMock.createMock( WritePersistenceManagerInterface.class );
    
        EasyMock.expect( rpm1.isApplicable( entryFilter, personIdentifiers ) ).andReturn( Boolean.TRUE );
        EasyMock.expect( rpm2.isApplicable( entryFilter, personIdentifiers ) ).andReturn( Boolean.TRUE );

        EasyMock.replay( entryFilter, rpm1, rpm2, wpm1 );
        
        List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        persistenceManagers.add(rpm1);
        persistenceManagers.add(rpm2);
        persistenceManagers.add(wpm1);
        
        persistenceLocator.setDynamicPersistenceManagers( persistenceManagers );

        Collection<ReadPersistenceManagerInterface> readPersistenceManagers = persistenceLocator.getReadPersistenceManagers( entryFilter, personIdentifiers );
        assertNotNull( readPersistenceManagers );
        assertEquals( readPersistenceManagers.size(), 2 );
    }



    @Test
    @Suite( groups = { "slowtest" } )
    public void testGetReadablePersistenceManagerNull( )
    {
        PersistenceLocator persistenceLocator = new PersistenceLocator();
        List<PersonIdentifierInterface> personIdentifiers = new ArrayList<PersonIdentifierInterface>();
     
        EntryFilterInterface entryFilter = EasyMock.createMock( EntryFilterInterface.class );
        ReadPersistenceManagerInterface rpm1 = EasyMock.createMock( ReadPersistenceManagerInterface.class );
        ReadPersistenceManagerInterface rpm2 = EasyMock.createMock( ReadPersistenceManagerInterface.class );
        WritePersistenceManagerInterface wpm1 = EasyMock.createMock( WritePersistenceManagerInterface.class );
    
        EasyMock.expect( rpm1.isApplicable( entryFilter, personIdentifiers ) ).andReturn( Boolean.FALSE );
        EasyMock.expect( rpm2.isApplicable( entryFilter, personIdentifiers ) ).andReturn( Boolean.FALSE );

        EasyMock.replay( entryFilter, rpm1, rpm2, wpm1 );
        
        List<PersistenceManagerInterface> persistenceManagers = new ArrayList<PersistenceManagerInterface>();
        persistenceManagers.add(rpm1);
        persistenceManagers.add(rpm2);
        persistenceManagers.add(wpm1);
        
        persistenceLocator.setDynamicPersistenceManagers( persistenceManagers );

        Collection<ReadPersistenceManagerInterface> readables = persistenceLocator.getReadPersistenceManagers( entryFilter, personIdentifiers );
        assertNotNull( readables );
        assertEquals( readables.size(), 0 );
    }
    
}
