

package gov.va.med.cds.integration.vim.ha;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.BaseDatatypesBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDataBuilder;
import gov.va.med.cds.testharness.vhim400.builders.ClinicalDomainBuilderFactoryInterface;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HASkillTrackingBuilder;
import gov.va.med.cds.testharness.vhim400.builders.HASkillTrackingBuilderFactory;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndSkillTrackingTest
    extends
        AbstractHealthAdapterEndToEndTest
{
    private static String READ_TEST_DOMAINENTRYPOINT_XPATH = "//skillsTracking/skillTracking";
    private static final String SPECIALIZED_DOMAIN_ENTRY_POINT = "filter:skillTrackingDomainEntryPointFilter";
    private static final String SKILL_TYPE_KEY = "skillType";
    private static final String SKILL_TYPE_TEST_TEXT = "Stretching";
    protected static final String TEST_CR_PATIENTIDENTITY_HDR = "test_sourceid_999999";


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testCreateUpdateDeleteSkillTracking( )
        throws Exception
    {

        String createRequestXml = createHaCreateXml( TEST_CUD_PATIENTIDENTITY_HDR, "skillsTracking",
                        TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, SKILL_TYPE_TEST_TEXT );

        // Create Skill Tracking
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );

        String[] hdrPatient1 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, TEST_CUD_PATIENTIDENTITY_HDR };
        String[][] patientIdentifiers = { hdrPatient1 };
        List<Map<String, String>> patients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-06-29" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        Map<String, String> optionalQueryParameters = new HashMap<String, String>();
        optionalQueryParameters.put( SKILL_TYPE_KEY, SKILL_TYPE_TEST_TEXT );
        String filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );

        clinicalDataDocument = readAndAssertDomainData( filterXml );

        List<Element> domainElements = clinicalDataDocument.selectNodes( "//skillType" );
        assertTrue( domainElements.size() > 0 );

        // Update Skill Tracking
        String updateRequestXml = createHaUpdateXml( TEST_CUD_PATIENTIDENTITY_HDR, "skillsTracking",
                        TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, recordIdentifier, "Activity Pacing" );

        clinicalDataDocument = updateAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_UPDATE1_TEMPLATE_ID, updateRequestXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID" );

        // Logically Delete Skill Tracking
        String logicalDeleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID,
                        recordIdentifier, LOGICAL_DELETE_RECORD_STATUS );

        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, logicalDeleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", true );

        //Delete Skill Tracking
        String deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

    }


    @Test
    @Suite( groups = { "deprecatedtest" } )
    @SuppressWarnings( "unchecked" )
    /**
     * Chk for default values in read response for skillSuccessLevel and allowAccessByClinicalStaff being 0 and true when inserted as blank
     */
    public void testSkillTrackingDefaultValuesChk( )
        throws Exception
    {
        doDelete( TEST_CUD_PATIENTIDENTITY_HDR );

        String createRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>HealthAdapterCreate1</templateId><patient><skillsTracking><skillTracking><patient><identifier><identity>test_sourceid_5000</identity><assigningFacility>200DOD</assigningFacility><assigningAuthority>USDOD</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><entryDate><literal>20120709180038-0700</literal></entryDate><skillSuccessLevel/><skillType>Stretching</skillType><skillFrequency>skillFrequency</skillFrequency><dataEnterer>dataEnterer</dataEnterer><allowAccessByClinicalStaff>false</allowAccessByClinicalStaff><comments>comments</comments></skillTracking></skillsTracking></patient></clinicaldata:ClinicalData>";
        Document clinicalDataDocument = createAndAssertDomainData( HA_CREATE_TEMPLATE_ID, createRequestXml );

        String[] hdrPatient1 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, TEST_CUD_PATIENTIDENTITY_HDR };
        String[][] patientIdentifiers = { hdrPatient1 };
        List<Map<String, String>> patients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-06-29" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        Map<String, String> optionalQueryParameters = new HashMap<String, String>();
        optionalQueryParameters.put( SKILL_TYPE_KEY, SKILL_TYPE_TEST_TEXT );
        String filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );

        clinicalDataDocument = readAndAssertDomainData( filterXml );

        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/skillSuccessLevel" ).getText().equals( "0" ) );
        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/allowAccessByClinicalStaff" ).getText().equals( "false" ) );

        doDelete( TEST_CUD_PATIENTIDENTITY_HDR );

        createRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>HealthAdapterCreate1</templateId><patient><skillsTracking><skillTracking><patient><identifier><identity>test_sourceid_11</identity><assigningFacility>200DOD</assigningFacility><assigningAuthority>USDOD</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><entryDate><literal>20120709180038-0700</literal></entryDate><skillSuccessLevel>100</skillSuccessLevel><skillType>Stretching</skillType><skillFrequency>skillFrequency</skillFrequency><dataEnterer>dataEnterer</dataEnterer><allowAccessByClinicalStaff></allowAccessByClinicalStaff><comments>comments</comments></skillTracking></skillsTracking></patient></clinicaldata:ClinicalData>";
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );

        String[] hdrPatient2 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "test_sourceid_11" };
        String[][] patientIdentifiers1 = { hdrPatient2 };
        patients = getResolvedPatients( patientIdentifiers1 );

        entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-06-29" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        optionalQueryParameters = new HashMap<String, String>();
        optionalQueryParameters.put( SKILL_TYPE_KEY, SKILL_TYPE_TEST_TEXT );
        filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );

        filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );
        clinicalDataDocument = readAndAssertDomainData( filterXml );

        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/skillSuccessLevel" ).getText().equals( "100" ) );
        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/allowAccessByClinicalStaff" ).getText().equals( "true" ) );
        doDelete( "test_sourceid_11" );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    /**
     * Chk for default values in read response for skillSuccessLevel and allowAccessByClinicalStaff being 0 and true only when inserted empty values for all fields except patient and entry date
     */
    public void testSkillTrackingNullChk( )
        throws Exception
    {
        doDelete( TEST_CUD_PATIENTIDENTITY_HDR );

        String createRequestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><clinicaldata:ClinicalData xmlns:clinicaldata=\"Clinicaldata\"><templateId>HealthAdapterCreate1</templateId><patient><skillsTracking><skillTracking><patient><identifier><identity>test_sourceid_5000</identity><assigningFacility>200DOD</assigningFacility><assigningAuthority>USDOD</assigningAuthority></identifier><name><prefix>Prefix</prefix><given>Given</given><middle>MiddleName</middle><family>FamilyName</family><suffix>Suffix</suffix><title>Title</title></name></patient><entryDate><literal>20120709180038-0700</literal></entryDate><skillSuccessLevel/><skillType></skillType><skillFrequency></skillFrequency><dataEnterer></dataEnterer><allowAccessByClinicalStaff></allowAccessByClinicalStaff><comments></comments></skillTracking></skillsTracking></patient></clinicaldata:ClinicalData>";
        Document clinicalDataDocument = createAndAssertDomainData( HA_CREATE_TEMPLATE_ID, createRequestXml );

        String[] hdrPatient1 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, TEST_CUD_PATIENTIDENTITY_HDR };
        String[][] patientIdentifiers = { hdrPatient1 };
        List<Map<String, String>> patients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-06-29" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        String filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, null );

        clinicalDataDocument = readAndAssertDomainData( filterXml );

        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/skillSuccessLevel" ).getText().equals( "0" ) );
        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/allowAccessByClinicalStaff" ).getText().equals( "true" ) );
        assertTrue( clinicalDataDocument.selectSingleNode( "//skillsTracking/skillTracking/entryDate/literal" ).getText()
                        .equals( "20120709180038-0700" ) );

        //doDelete( TEST_CUD_PATIENTIDENTITY_HDR );

    }


    private void doDelete( String patientId )
    {
        hdrJdbcTemplate.update( "DELETE FROM SKILL_TRACKING WHERE PATIENT_IDENTITY = '" + patientId + "'" );
    }


    protected String createHaCreateXml( String patientIdentifier, String entryPoint, String templateId, String skillType )
    {
        return createHaXml( patientIdentifier, entryPoint, templateId, null, skillType );

    }


    protected String createHaUpdateXml( String patientIdentifier, String entryPoint, String templateId, String recordIdentifier, String skillType )
    {
        return createHaXml( patientIdentifier, entryPoint, templateId, recordIdentifier, skillType );

    }


    protected String createHaXml( String patientIdentifier, String entryPoint, String templateId, String recordIdentifier, String skillType )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( templateId, DomainEntryPoint.SkillTracking );
        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        HASkillTrackingBuilderFactory factory = new HASkillTrackingBuilderFactory();

        HASkillTrackingBuilder haSkillTrackingBuilder;
        if ( recordIdentifier != null )
        {
            haSkillTrackingBuilder = new HASkillTrackingBuilder( recordIdentifier );
        }
        else
        {
            haSkillTrackingBuilder = new HASkillTrackingBuilder();
        }
        factory.setSkillTrackingBuilder( haSkillTrackingBuilder );

        domainEntryPointsWrappersMap.put( "SkillTracking", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = null;
        if ( patientIdentifier == null )
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest", "200DOD", "USDOD" );
        }
        else
        {
            patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest", patientIdentifier, "200DOD", "USDOD" );
        }

        Document clinicalDataInsert = clinicalDataBuilder.createClinicalData( templateId, 1, patient, skillType );
        clinicalDataBuilder.addAuditInfo( clinicalDataInsert.getRootElement(), CLIENT_NAME );

        return clinicalDataInsert.asXML();
    }


    protected String createHASkillTrackingDeleteXml( String entryPoint, String templateId, String recordIdentifierIdentity, String recordStatus )
    {
        Map<String, DomainEntryPoint> domainEntryPointsMap = new HashMap<String, DomainEntryPoint>();
        domainEntryPointsMap.put( templateId, DomainEntryPoint.SkillTracking );
        ClinicalDataBuilder clinicalDataBuilder = new ClinicalDataBuilder();
        clinicalDataBuilder.setDomainEntryPointsMap( domainEntryPointsMap );

        Map<String, ClinicalDomainBuilderFactoryInterface> domainEntryPointsWrappersMap = new HashMap<String, ClinicalDomainBuilderFactoryInterface>();
        HASkillTrackingBuilderFactory factory = new HASkillTrackingBuilderFactory();
        factory.setSkillTrackingBuilder( new HASkillTrackingBuilder() );
        domainEntryPointsWrappersMap.put( "SkillTracking", factory );
        clinicalDataBuilder.setDomainEntryPointsWrappersMap( domainEntryPointsWrappersMap );

        Element patient = BaseDatatypesBuilder.createHL72PersonIdentifier( "HealthAdapterTest", "200DOD", "USDOD" );
        Document clinicalDataInsert = clinicalDataBuilder.deleteClinicalData( domainEntryPointsMap.get( templateId ), templateId, patient,
                        recordIdentifierIdentity, recordStatus );
        clinicalDataBuilder.addAuditInfo( clinicalDataInsert.getRootElement(), CLIENT_NAME );

        return clinicalDataInsert.asXML();
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testSkillsTrackingReadSkillTypeHistory( )
        throws Exception
    {
        // Create Skill Tracking
        String createRequestXml = createHaCreateXml( "test_sourceid_122", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Stretching" );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier0 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        createRequestXml = createHaCreateXml( "test_sourceid_122", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Stretching" );
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier1 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        createRequestXml = createHaCreateXml( "test_sourceid_122", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Activity Pacing" );
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier2 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        //no dates in filter
        String[] hdrPatient1 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "test_sourceid_122" };
        String[][] patientIdentifiers = { hdrPatient1 };
        List<Map<String, String>> patients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        Map<String, String> optionalQueryParameters = new HashMap<String, String>();
        optionalQueryParameters.put( SKILL_TYPE_KEY, SKILL_TYPE_TEST_TEXT );
        String filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );

        clinicalDataDocument = readAndAssertDomainData( filterXml );
        List<Element> domainElements = clinicalDataDocument.selectNodes( "//skillType" );
        assertTrue( domainElements.size() > 0 );

        for ( Element domainElement : domainElements )
        {
            assertTrue( domainElement.getText().equals( "Stretching" ) );
            assertTrue( !domainElement.getText().equals( "Activity Pacing" ) );
        }

        //dates in filter
        entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-06-29" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        optionalQueryParameters = new HashMap<String, String>();
        optionalQueryParameters.put( SKILL_TYPE_KEY, SKILL_TYPE_TEST_TEXT );
        filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT, optionalQueryParameters );

        clinicalDataDocument = readAndAssertDomainData( filterXml );

        domainElements = clinicalDataDocument.selectNodes( "//skillType" );
        assertTrue( domainElements.size() > 0 );

        for ( Element domainElement : domainElements )
        {
            assertTrue( domainElement.getText().equals( "Stretching" ) );
            assertTrue( !domainElement.getText().equals( "Activity Pacing" ) );
        }

        //Delete Skill Tracking
        String deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier0,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

        //Delete Skill Tracking
        deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier1,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

        //Delete Skill Tracking
        deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier2,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "deprecatedtest" } )
    public void testSkillsTrackingReadLatestSkillTypes( )
        throws Exception
    {

        // Create Skill Tracking
        String createRequestXml = createHaCreateXml( "test_sourceid_121", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Stretching" );
        Document clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        List<Element> recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        createRequestXml = createHaCreateXml( "test_sourceid_121", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Stretching" );
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        String recordIdentifier1 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        createRequestXml = createHaCreateXml( "test_sourceid_121", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Activity Pacing" );
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier2 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        createRequestXml = createHaCreateXml( "test_sourceid_121", "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        "Activity Pacing" );
        clinicalDataDocument = createAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID, createRequestXml );
        recordIdentifierList = clinicalDataDocument.selectNodes( RECORD_IDENTIFIER_IDENTITY_XPATH );
        assertTrue( recordIdentifierList.size() > 0 );
        String recordIdentifier3 = ( ( Element )recordIdentifierList.get( 0 ) ).getText();

        //no dates filter
        String[] hdrPatient1 = { ASSIGNINGAUTHORITY_HDR, ASSIGNING_FACILITY_HDR, "test_sourceid_121" };
        String[][] patientIdentifiers = { hdrPatient1 };
        List<Map<String, String>> patients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        String filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT );

        clinicalDataDocument = readAndAssertDomainData( filterXml );
        List<Element> domainElements = clinicalDataDocument.selectNodes( "//skillType" );
        assertTrue( domainElements.size() > 0 );

        for ( Element domainElement : domainElements )
        {
            if ( domainElement.getText().equals( "Stretching" ) )
            {
                assertTrue( domainElement.getText().equals( "Stretching" ) );
            }
            else
            {
                assertTrue( domainElement.getText().equals( "Activity Pacing" ) );
            }

        }

        //out of range dates filter
        entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2013-01-01" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT );

        clinicalDataDocument = readAndAssertNoDomainData( filterXml );

        //dates filter
        entryPointFilter = new HashMap<String, String>();
        entryPointFilter.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "SkillTracking" );
        entryPointFilter.put( FilterBuilder.QUERY_NAME_KEY, "queryName" );
        entryPointFilter.put( FilterBuilder.START_DATE_KEY, "2012-01-01" );
        entryPointFilter.put( FilterBuilder.END_DATE_KEY, "2013-06-01" );

        entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        filterXml = FilterBuilder.buildFilterWithEdiPi( FILTER_ID, entryPointFilterMaps, patients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ), SPECIALIZED_DOMAIN_ENTRY_POINT );

        clinicalDataDocument = readAndAssertDomainData( filterXml );

        domainElements = clinicalDataDocument.selectNodes( "//skillType" );
        assertTrue( domainElements.size() > 0 );

        for ( Element domainElement : domainElements )
        {
            if ( domainElement.getText().equals( "Stretching" ) )
            {
                assertTrue( domainElement.getText().equals( "Stretching" ) );
            }
            else
            {
                assertTrue( domainElement.getText().equals( "Activity Pacing" ) );
            }

        }

        //Delete Skill Tracking
        String deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier,
                        DELETE_RECORD_STATUS );

        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

        //Delete Skill Tracking
        deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier1,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

        deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier2,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

        deleteXml = createHASkillTrackingDeleteXml( "skillsTracking", TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, recordIdentifier3,
                        DELETE_RECORD_STATUS );
        clinicalDataDocument = deleteAndAssertDomainData( TemplateIdHelper.HEALTH_ADAPTER_DELETE1_TEMPLATE_ID, deleteXml, "SKILL_TRACKING",
                        "SKILL_TRACKING_ID", false );

    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainData( String filter )
        throws Exception
    {
        Document clinicalDataDocument = super.readAndAssertDomainData( filter );

        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( READ_TEST_DOMAINENTRYPOINT_XPATH );
        assertTrue( domainElements.size() > 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertNoDomainData( String templateId, String filterId, String filter )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );
        String requestId = new UniqueIdentifier().toString();
        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, requestId );

        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );
        //assertTrue( !createXmlRequestId.equals( requestIdFromResponse ) );
        // Check for domain entry point elements
        List<Element> domainElements = clinicalDataDocument.selectNodes( READ_TEST_DOMAINENTRYPOINT_XPATH );
        assertTrue( domainElements.size() == 0 );
        return clinicalDataDocument;
    }


    protected Document readAndAssertNoDomainData( String filter )
        throws Exception
    {
        return readAndAssertNoDomainData( HA_READ_TEMPLATE_ID, FILTER_ID, filter );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readAndAssertDomainDataWithErrors( String templateId, String filterId, String filter )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( true );
        String requestId = new UniqueIdentifier().toString();
        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, requestId );

        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        String requestIdFromResponse = clinicalDataDocument.selectSingleNode( REQUEST_ID_XPATH ).getText();
        assertTrue( requestId.equals( requestIdFromResponse ) );
        //assertTrue( !createXmlRequestId.equals( requestIdFromResponse ) );

        return clinicalDataDocument;
    }


    protected String getskillsTrackingEntryPointXpath( )
    {
        return "//skillsTracking";
    }

}
