

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;
import gov.va.med.cds.uniqueidentifier.UniqueIdentifier;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.junit.Before;
import org.junit.Test;


public class RequestWithNullParametersTest
    extends
        AbstractEndToEndTest
{
    private static String STATUS_ACTIVE = "ACTIVE";
    private static String QUERY_NAME_BASE = "NonVAMedicationsRead2.NonVAMedication.patient";
    private static String PATIENTIDENTITY1 = "100839";
    private static String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static String PATIENTIDENTITY2 = "25";
    private static String ASSIGNINGFACILITY2 = "578";
    private static final String PATIENT_IDENTITY_VISTA = "100600";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";
    private static final String PATIENT_IDENTITY_VISTA_EXAM_REQUEST = "78";
    private static final String PATHWAYS_DEFAULT_ERROR_RESPONSE_URI = "pathwaysdata:PathwaysData xmlns:pathwaysdata";
    private static final String EXAM_URI = "examsdata:RequestsAndExamsData xmlns:examsdata";
    private static final String APPOINTMENTS_URI = "appointmentsdata:AppointmentsData xmlns:appointmentsdata";
    private static final String CLINICAL_PATH_URI = "clinicaldata:ClinicalData xmlns:clinicaldata";
    private static final String RPC_XPATH_ERRORSECTION = "//errorSection";
    private static String RPC_XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "//errorSection/fatalErrors/fatalError/errorCode";
    private static String RPC_XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "//errorSection/fatalErrors/fatalError/displayMessage";

    protected static String DOMAIN_ENTRY_POINT = "NonVaMedicationEvent";
    protected static String XPATH_DOMAINENTRYPOINT = "//nonVaMedicationEvents";
    protected static String XPATH_ERRORSECTION = "//errorSection";
    protected static String XPATH_TEMPLATE_ID = "//templateId";
    private static String CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE = "//errorSection/fatalErrors/fatalError/errorCode";
    private static String CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG = "//errorSection/fatalErrors/fatalError/displayMessage";
    private static final String READ_REQUEST_INPUT_PARAMETERS_NULL = "READ_REQUEST_INPUT_PARAMETERS_NULL";
    private static final String READ_REQUEST_INPUT_PARAMETERS_NULL_MSG = "Read request cannot have empty input parameters(s). Empty input parameter(s) are ";

    private static final String CDS_AUDIT_CLOB_STORE_ERROR = "CDS_AUDIT_CLOB_STORE_ERROR";
    private static final String WRITE_REQUEST_XML_INVALID = "WRITE_REQUEST_XML_INVALID";
    private static final String WRITE_REQUEST_INPUT_PARAMETERS_NULL = "WRITE_REQUEST_INPUT_PARAMETERS_NULL";
    private static final String WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG = "Write request cannot have empty input parameters(s). Empty input parameter(s) are ";
    private static final String CANT_MATCH_TEMPLATE_TO_DELEGATE = "CANT_MATCH_TEMPLATE_TO_DELEGATE";
    private static final String CANT_MATCH_TEMPLATE_TO_DELEGATE_MSG = "Can not match template null to available service delegate.";
    
    private static final String TEMPLATE_ID_PARAMETER_NAME = "TemplateId ";
    private static final String CUAD_REQUEST_PARAMETER_NAME = "CUADRequestXML ";
    private static final String FILTER_REQUEST_PARAMETER_NAME = "FilterRequestXML ";
    private static final String FILTER_ID_PARAMETER_NAME = "FilterId ";
    private static final String REQUEST_ID_PARAMETER_NAME = "RequestId ";

    @Resource
    protected TemplateRequestProcessor requestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeRequestWithNullParametersTestClassSetUp( )
        throws Exception
    {
        requestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithEmptyFilterXml( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = readClinicalDataAndAssertErrors( TemplateIdHelper.NONVA_MEDICATIONS_READ2_TEMPLATE_ID, null,
                        TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, new UniqueIdentifier().toString(), "FilterRequestXML" );

        assertTrue( clinicalDataDocument.asXML().contains( CLINICAL_PATH_URI ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithEmptyTempalteId( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = readClinicalDataAndAssertErrors( null, filterXml, TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER,
                        new UniqueIdentifier().toString(), "TemplateId" );

        assertTrue( clinicalDataDocument.asXML().contains( "<templateId>CdsResponse400</templateId>" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithEmptyFilterId( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = readClinicalDataAndAssertErrors( TemplateIdHelper.NONVA_MEDICATIONS_READ2_TEMPLATE_ID, filterXml, null,
                        new UniqueIdentifier().toString(), "FilterId" );

        assertTrue( clinicalDataDocument.asXML().contains( CLINICAL_PATH_URI ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithEmptyRequestId( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = readClinicalDataAndAssertErrors( TemplateIdHelper.NONVA_MEDICATIONS_READ2_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, null, "RequestId" );

        assertTrue( clinicalDataDocument.asXML().contains( CLINICAL_PATH_URI ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithAllNullParams( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = readClinicalDataAndAssertErrors( null, null, "", " ", "TemplateId FilterId FilterRequestXML RequestId" );

        assertTrue( clinicalDataDocument.asXML().contains( "<templateId>CdsResponse400</templateId>" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithInvalidTemplateId( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = requestProcessor.readClinicalData( "INVALID_TEMPLATE_ID", filterXml,
                        TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( clinicalDataDocument.asXML().contains( "<templateId>CdsResponse400</templateId>" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithAllInvalidParams( )
        throws Exception
    {
        Document clinicalDataDocument = readClinicalDataAndAssertErrors( "INVALID_TEMPLATE_ID", "INVALID_FILTER_XML", "INVALID_FILTER_ID", "",
                        "RequestId" );
        assertNotNull( clinicalDataDocument );
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( clinicalDataDocument.asXML().contains( "<templateId>CdsResponse400</templateId>" ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithInvalidFilterXml( )
        throws Exception
    {
        Document clinicalDataDocument = requestProcessor.readClinicalData( TemplateIdHelper.NONVA_MEDICATIONS_READ2_TEMPLATE_ID,
                        "INVALID_FILTER_XML", TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, "XYZ" );
        assertNotNull( clinicalDataDocument );
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( clinicalDataDocument.asXML().contains( CLINICAL_PATH_URI ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    @SuppressWarnings( "unchecked" )
    public void testNonVAMedsRequestsWithInvalidFilterId( )
        throws Exception
    {
        Map<String, String> resolvedPatient = new HashMap<String, String>();
        resolvedPatient.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNING_FACILITY_VISTA_580 );
        resolvedPatient.put( FilterBuilder.IDENTITY, PATIENTIDENTITY1 );

        List<Map<String, String>> resolvedPatientsList = new ArrayList<Map<String, String>>();
        resolvedPatientsList.add( resolvedPatient );

        Map<String, String> resolvedPatient1 = new HashMap<String, String>();
        resolvedPatient1.put( FilterBuilder.ASSIGNING_AUTHORITY_KEY, ASSIGNING_AUTHORITY_VISTA );
        resolvedPatient1.put( FilterBuilder.ASSIGNING_FACILITY, ASSIGNINGFACILITY2 );
        resolvedPatient1.put( FilterBuilder.IDENTITY, PATIENTIDENTITY2 );
        resolvedPatientsList.add( resolvedPatient1 );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, DOMAIN_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, QUERY_NAME_BASE );

        String filterXml = createNonVaMedsSinglePatientDataFilter( TemplateIdHelper.NONVAMED_SINGLE_PATIENT_FILTER, entryPointFilterMap,
                        resolvedPatientsList, STATUS_ACTIVE );

        Document clinicalDataDocument = requestProcessor.readClinicalData( TemplateIdHelper.NONVA_MEDICATIONS_READ2_TEMPLATE_ID, filterXml,
                        "INVALID_FILTER_ID", "XYZ" );
        assertNotNull( clinicalDataDocument );
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( clinicalDataDocument.asXML().contains( CLINICAL_PATH_URI ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithEmptyFiltertXml( )
        throws Exception
    {

        Document dataDocument = readRpcDataAndAssertErrors( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, null,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, new UniqueIdentifier().toString(), "FilterRequestXML" );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );

    }


    private String createFilter( )
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        // build filter
        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiers( TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime ).asXML();

        return filterXml;
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testAppointmentsWithEmptyTemplate( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = readRpcDataAndAssertErrors( null, filterXml, TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        new UniqueIdentifier().toString(), "TemplateId" );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testAppointmentsWithEmptyTemplateNReqId( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = readRpcDataAndAssertErrors( null, filterXml, TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, null,
                        "TemplateId RequestId" );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testAppointmentsWithEmptyTemplateNFilterIdNReqId( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = readRpcDataAndAssertErrors( null, filterXml, null, null, "TemplateId FilterId RequestId" );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testAppointmentsWithEmptyTemplateNFilterIdNReqIdNXml( )
        throws Exception
    {
        Document dataDocument = readRpcDataAndAssertErrors( null, "XYZ", null, null, "TemplateId FilterId RequestId" );
        assertTrue( ( dataDocument.asXML() ).contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithEmptyFilterId( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = readRpcDataAndAssertErrors( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml, null,
                        new UniqueIdentifier().toString(), FILTER_ID_PARAMETER_NAME );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithEmptyReqId( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = readRpcDataAndAssertErrors( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, null, REQUEST_ID_PARAMETER_NAME );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testAppointmentsWithAllNullParams( )
        throws Exception
    {
        String filterXml = createFilter();
        Document dataDocument = readRpcDataAndAssertErrors( null, null, "", " ", "TemplateId FilterId FilterRequestXML RequestId" );
        assertTrue( ( dataDocument.asXML() ).contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithInvalidTemplateId( )
        throws Exception
    {
        String filterXml = createFilter();
        Document dataDocument = requestProcessor.readClinicalData( "INVALID_TEMPLATE_ID", filterXml, TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER,
                        new UniqueIdentifier().toString() );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( CLINICAL_PATH_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithInvalidFilterDtls( )
        throws Exception
    {
        String filterXml = createFilter();

        Document dataDocument = requestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, "INVALID_FILTER_XML",
                        "INVALID_FILTER_ID", "" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithAllInvalidParams( )
        throws Exception
    {
        Document dataDocument = requestProcessor.readClinicalData( "INVALID_TEMPLATEID", "INVALID_FILTER_XML", "INVALID_FILTER_ID", "XYZ2" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( CLINICAL_PATH_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithInvalidFilterXml( )
        throws Exception
    {
        Document dataDocument = requestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, "INVALID_FILTER_XML",
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, "XYZ" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithInvalidFilterNTemplateId( )
        throws Exception
    {
        String filterXml = createFilter();
        Document dataDocument = requestProcessor.readClinicalData( "INVALID_TEMPLATEID", filterXml, "INVALID_FILTER_ID", "XYZ" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( CLINICAL_PATH_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithInvalidFilterId( )
        throws Exception
    {
        String filterXml = createFilter();
        Document dataDocument = requestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml, "INVALID_FILTER_ID", "XYZ" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithFilterWithNoClient( )
        throws Exception
    {
        String startDate = "2002-01-01";
        String endDate = "2011-06-01";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";

        // build resolved patients
        String[] vistaPatient521 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA };
        String[][] patientIdentifiers = { vistaPatient521 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapAppts = new HashMap<String, String>();
        entryPointFilterMapAppts.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Appointment" );
        entryPointFilterMapAppts.put( FilterBuilder.QUERY_NAME_KEY, "Appointment-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapAppts );

        String filterXml = FilterBuilder.buildAppointmentsFilterElementWithResolvedIdentfiersNoClientName(
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime ).asXML();
        Document dataDocument = requestProcessor.readClinicalData( TemplateIdHelper.APPOINTMENTS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.APPOINTMENTS_SINGLE_PATIENT_FILTER, "XYZ" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );
        assertTrue( ( dataDocument.asXML() ).contains( APPOINTMENTS_URI ) );

    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testExamsWithEmptyTemplate( )
        throws Exception
    {
        String filterXml = createExamFilter();

        Document dataDocument = readRpcDataAndAssertErrors( null, filterXml, TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        new UniqueIdentifier().toString(), TEMPLATE_ID_PARAMETER_NAME );

        assertTrue( ( dataDocument.asXML() ).contains( EXAM_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testExamsWithEmptyFilterId( )
        throws Exception
    {
        String filterXml = createExamFilter();

        Document dataDocument = readRpcDataAndAssertErrors( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml, null,
                        new UniqueIdentifier().toString(), FILTER_ID_PARAMETER_NAME );
        assertTrue( ( dataDocument.asXML() ).contains( EXAM_URI ) );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testExamsWithEmptyReqId( )
        throws Exception
    {
        String filterXml = createExamFilter();

        Document dataDocument = readRpcDataAndAssertErrors( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, null, REQUEST_ID_PARAMETER_NAME );
        assertTrue( ( dataDocument.asXML() ).contains( EXAM_URI ) );
    }


    @SuppressWarnings( "unchecked" )
//    @Test
//    @Suite( groups = { "invalidtest" } )
    public void testExamsWithAllNullParams( )
        throws Exception
    {
        String filterXml = createExamFilter();

        Document dataDocument = readRpcDataAndAssertErrors( null, null, "", " ", "TemplateId FilterId FilterRequestXML RequestId" );
        assertTrue( ( dataDocument.asXML() ).contains( PATHWAYS_DEFAULT_ERROR_RESPONSE_URI ) );
    }


    private String createExamFilter( )
    {
        String startDate = null;
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, null ).asXML();

        return filterXml;
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testAppointmentsWithNullParams( )
        throws Exception
    {
        Document dataDocument = requestProcessor.readClinicalData( "", "", "", "" );
        assertNotNull( dataDocument );
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testNonVAMedsRequestsWithNullParams( )
        throws Exception
    {
        Document clinicalDataDocument = requestProcessor.readClinicalData( "", "", "", "" );
        assertNotNull( clinicalDataDocument );
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithNullWriteXml( )
        throws Exception
    {
        Document clinicalDataDocument = createClinicalDataAndAssertErrors( null, TemplateIdHelper.HEALTH_ADAPTER_CREATE1_TEMPLATE_ID,
                        new UniqueIdentifier().toString(), WRITE_REQUEST_INPUT_PARAMETERS_NULL, WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, CUAD_REQUEST_PARAMETER_NAME );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithNullXmlNTemplateId( )
        throws Exception
    {
        Document clinicalDataDocument = createClinicalDataAndAssertErrors( null, null, new UniqueIdentifier().toString(),
                        WRITE_REQUEST_INPUT_PARAMETERS_NULL, WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, CUAD_REQUEST_PARAMETER_NAME );

    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithCDS2xTemplate( )
        throws Exception
    {

        Document clinicalDataDocument = createClinicalDataAndAssertErrors( "xyz", TemplateIdHelper.INTOLERANCE_CONDITION_CREATEORUPDATE_TEMPLATE_ID,
                        null, WRITE_REQUEST_INPUT_PARAMETERS_NULL, WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, REQUEST_ID_PARAMETER_NAME );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithAllNullParams( )
        throws Exception
    {

        Document clinicalDataDocument = createClinicalDataAndAssertErrors( null, null, null, WRITE_REQUEST_INPUT_PARAMETERS_NULL,
                        WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, CUAD_REQUEST_PARAMETER_NAME );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithAllEmptyParams( )
        throws Exception
    {

        Document clinicalDataDocument = createClinicalDataAndAssertErrors( null, null, null, WRITE_REQUEST_INPUT_PARAMETERS_NULL,
                        WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, CUAD_REQUEST_PARAMETER_NAME );
    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithNoTemplateId( )
        throws Exception
    {
        Document clinicalDataDocument = createClinicalDataAndAssertErrors( "xyz", null, "request id", WRITE_REQUEST_INPUT_PARAMETERS_NULL,
                        WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, TEMPLATE_ID_PARAMETER_NAME );

    }


    @SuppressWarnings( "unchecked" )
    @Test
    @Suite( groups = { "checkintest" } )
    public void testWriteRequestWithNoRequestId( )
        throws Exception
    {

        Document clinicalDataDocument = createClinicalDataAndAssertErrors( "requestXML", TemplateIdHelper.DBQ_CREATE1_TEMPLATE_ID, null,
                        WRITE_REQUEST_INPUT_PARAMETERS_NULL, WRITE_REQUEST_INPUT_PARAMETERS_NULL_MSG, REQUEST_ID_PARAMETER_NAME );
    }


    private String createNonVaMedsSinglePatientDataFilter( String filterId, Map<String, String> entryPointFilter,
                    List<Map<String, String>> resolvedPatients, String statusValue )
    {
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilter );

        return FilterBuilder.buildNonVaMedFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients, statusValue,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );
    }


    @SuppressWarnings( "unchecked" )
    protected Document readClinicalDataAndAssertErrors( String templateId, String filter, String filterId, String requestId, String errorMsgContent )
        throws Exception
    {
        String errorTemplateId = null;

        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, requestId );
        assertNotNull( clinicalDataDocument );

        List<Element> errorSections = errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        SAXReader reader = new SAXReader();

        Node templateIdNode = clinicalDataDocument.selectSingleNode( XPATH_TEMPLATE_ID );

        if ( templateIdNode instanceof Element )
        {
            errorTemplateId = ( ( Element )templateIdNode ).getText();
            if ( errorTemplateId.equals( "CdsResponse400" ) )
            {
                CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE = "//errorSection/fatalErrors/errorCode";
                CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG = "//errorSection/fatalErrors/displayMessage";
            }
            else
            {
                CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE = "//errorSection/fatalErrors/fatalError/errorCode";
                CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG = "//errorSection/fatalErrors/fatalError/displayMessage";
            }

        }

        List<Node> fatalErrorNodes = clinicalDataDocument.selectNodes( CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE );
        Assert.assertTrue( fatalErrorNodes.size() == 1 );
        assertTrue( fatalErrorNodes.get( 0 ).getText().contains( READ_REQUEST_INPUT_PARAMETERS_NULL ) );

        Node fatalErrorMsgNode = clinicalDataDocument.selectSingleNode( CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG );
        assertNotNull( fatalErrorMsgNode.getText() );
        assertTrue( fatalErrorMsgNode.getText().contains( READ_REQUEST_INPUT_PARAMETERS_NULL_MSG + errorMsgContent ) );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document createClinicalDataAndAssertErrors( String writeRequest, String templateId, String requestId, String errorCode, String errMsg,
                    String errorMsgContent )
        throws Exception
    {
        String errorTemplateId = null;

        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.createClinicalData( writeRequest, templateId, requestId );
        assertNotNull( clinicalDataDocument );

        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        Node templateIdNode = clinicalDataDocument.selectSingleNode( XPATH_TEMPLATE_ID );

        if ( templateIdNode instanceof Element )
        {
            errorTemplateId = ( ( Element )templateIdNode ).getText();
            if ( errorTemplateId.equals( "CdsResponse400" ) || ( errorTemplateId.contains( "Create" ) && ( !errorTemplateId.contains( "DBQ" ) ) ) )
            {
                CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE = "//errorSection/fatalErrors/errorCode";
                CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG = "//errorSection/fatalErrors/displayMessage";
            }
            else
            {
                CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE = "//errorSection/fatalErrors/fatalError/errorCode";
                CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG = "//errorSection/fatalErrors/fatalError/displayMessage";
            }

        }

        List<Node> fatalErrorNodes = clinicalDataDocument.selectNodes( CDS_XPATH_ERRORSECTION_FATAL_ERRORCODE );
        Assert.assertTrue( fatalErrorNodes.size() == 1 );
        assertTrue( fatalErrorNodes.get( 0 ).getText().contains( errorCode ) );

        Node fatalErrorMsgNode = clinicalDataDocument.selectSingleNode( CDS_XPATH_ERRORSECTION_FATAL_DISPLAYMSG );
        assertNotNull( fatalErrorMsgNode.getText() );
        String msgToChk = null;
        if ( errMsg == null )
        {
            msgToChk = errorMsgContent;
        }
        else
        {
            msgToChk = errMsg + errorMsgContent;
        }
        assertTrue( fatalErrorMsgNode.getText().contains( msgToChk ) );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readRpcDataAndAssertErrors( String templateId, String filter, String filterId, String requestId, String errorMsgContent )
        throws Exception
    {
        String errorTemplateId = null;

        requestProcessor.setValidateReadResponseXML( false );

        Document dataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, requestId );
        assertNotNull( dataDocument );

        List<Element> errorSections = dataDocument.selectNodes( RPC_XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        Node templateIdNode = dataDocument.selectSingleNode( XPATH_TEMPLATE_ID );

        if ( templateIdNode instanceof Element )
        {
            errorTemplateId = ( ( Element )templateIdNode ).getText();

            if ( errorTemplateId.equals( "PathwaysResponse400" ) )
            {
                RPC_XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "//errorSection/fatalErrors/errorCode";
                RPC_XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "//errorSection/fatalErrors/displayMessage";
            }
            else
            {
                RPC_XPATH_ERRORSECTION_FATALERROR_ERRORCODE = "//errorSection/fatalErrors/fatalError/errorCode";
                RPC_XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG = "//errorSection/fatalErrors/fatalError/displayMessage";
            }
        }

        List<Node> fatalErrorNodes = dataDocument.selectNodes( RPC_XPATH_ERRORSECTION_FATALERROR_ERRORCODE );
        Assert.assertTrue( fatalErrorNodes.size() == 1 );
        assertTrue( fatalErrorNodes.get( 0 ).getText().contains( READ_REQUEST_INPUT_PARAMETERS_NULL ) );

        Node fatalErrorMsgNode = dataDocument.selectSingleNode( RPC_XPATH_ERRORSECTION_FATALERROR_DISPLAYMSG );
        assertNotNull( fatalErrorMsgNode.getText() );
        assertTrue( fatalErrorMsgNode.getText().contains( READ_REQUEST_INPUT_PARAMETERS_NULL_MSG + errorMsgContent ) );

        return dataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readClinicalDataAndAssertNoErrors( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        return clinicalDataDocument;
    }


    @SuppressWarnings( "unchecked" )
    protected Document readRpcDataAndAssertNoErrors( String templateId, String filter, String filterId )
        throws Exception
    {
        requestProcessor.setValidateReadResponseXML( false );

        Document clinicalDataDocument = requestProcessor.readClinicalData( templateId, filter, filterId, new UniqueIdentifier().toString() );
        assertNotNull( clinicalDataDocument );

        // Check for error sections
        List<Element> errorSections = clinicalDataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        return clinicalDataDocument;
    }
    
}
