

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertEquals;

import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@RunWith( SuiteAwareSpringRunner.class )
public class EndToEndReadImmunizationsTest
    extends
        AbstractEndToEndTest
{
    private static final Log LOGGER = LogFactory.getLog( EndToEndReadImmunizationsTest.class );

    private static final String IMMUNIZATION_ENTRY_POINT = "ImmunizationEvent";

    private static final String IMMUNIZATION__QUERY_NAME = "ID_IMM";

    protected TemplateRequestProcessor templateRequestProcessor;

    private static final String XPATH_IMMUNIZATIONEVENT = "//patients/patient/immunizationEvents/immunizationEvent";


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadHdrVistaTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testImmunizations( )
        throws Exception
    {
        String filterId = TemplateIdHelper.IMMUNIZATION_SINGLE_PATIENT_FILTER;
        String templateId = TemplateIdHelper.IMMUNIZATIONS_READ3_TEMPLATE_ID;
        String[] vistaPatient578 = { "USVHA", "578", "129" };
        String[] vistaPatient580 = { "USVHA", "580", "84" };
        String[][] patientIdentifiers = { vistaPatient578, vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        Map<String, String> entryPointFilterMap = new HashMap<String, String>();
        entryPointFilterMap.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, IMMUNIZATION_ENTRY_POINT );
        entryPointFilterMap.put( FilterBuilder.QUERY_NAME_KEY, IMMUNIZATION__QUERY_NAME );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMap );
        String filterXml = FilterBuilder.buildFilterWithResolvedIdentfiers( filterId, entryPointFilterMaps, resolvedPatients,
                        DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format( new Date() ) );

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( filterXml );
        }

        templateRequestProcessor.setValidateReadResponseXML( true );
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        Document clinicalDataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );

        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( clinicalDataDocument.asXML() );
        }

        assertEquals( 9, clinicalDataDocument.selectNodes( XPATH_IMMUNIZATIONEVENT ).size() );
    }
}
