

package gov.va.med.cds.integration.vhim400;


import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import gov.va.med.cds.integration.AbstractEndToEndTest;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.request.RequestProcessorInterface;
import gov.va.med.cds.request.TemplateRequestProcessor;
import gov.va.med.cds.testharness.vhim400.TemplateIdHelper;
import gov.va.med.cds.testharness.vhim400.builders.FilterBuilder;
import gov.va.med.cds.testharness.xml.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareSpringRunner.class )
@SuppressWarnings( "unchecked" )
public class EndToEndReadExamRequestAndExamTest
    extends
        AbstractEndToEndTest
{
    private static final String PATIENT_IDENTITY_VISTA_EXAM_REQUEST = "78";
    private static final String PATIENT_IDENTITY_VISTA_EXAM = "78";
    private static final String PATIENT_IDENTITY_VISTA_FAILING = "3";
    private static final String PATIENT_IDENTITY_VISTA_FAILING_1 = "patient_identity_1";
    private static final String ASSIGNING_FACILITY_VISTA_580 = "580";
    private static final String ASSIGNING_FACILITY_VISTA_578 = "578";
    private static final String ASSIGNINGFACILITY_FAILURE_1 = "504";
    private static final String ASSIGNING_AUTHORITY_VISTA = "USVHA";
    private static final String PATIENT_IDENTITY_VISTA_FAILING_2 = "999999";
    private static final String ASSIGNINGFACILITY_FAILURE_2 = "503";

    private static final String XPATH_ERRORSECTION = "//errorSection";
    private static final String XPATH_ERRORSECTION_WARNING_ERRORCODE = "/examsdata:RequestsAndExamsData/errorSection/warnings/warning/errorCode";
    private static final String XPATH_EXAMREQUEST_ERRORSECTION_WARNING = "/examsdata:RequestsAndExamsData/errorSection/warnings/warning";
    private static final String XPATH_EXAMREQUEST_ERRORSECTION_WARNINGERRORCODE = "/examsdata:RequestsAndExamsData/errorSection/warnings/warning/errorCode";
    private static final String XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE = "/examsdata:RequestsAndExamsData/errorSection/fatalErrors/fatalError/errorCode";
    private static final String XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE_DISPLAYMSG = "/examsdata:RequestsAndExamsData/errorSection/fatalErrors/fatalError/displayMessage";
    private static final String XPATH_ERRORSECTION_WARNING_DISPLAYMSG = "/examsdata:RequestsAndExamsData/errorSection/warnings/warning/displayMessage";
    private static final String XPATH_ERRORSECTION_ERROR = "/examsdata:RequestsAndExamsData/errorSection/errors/error";
    private static final String XPATH_ERRORSECTION_ERROR_ERRORCODE = "/examsdata:RequestsAndExamsData/errorSection/errors/error/errorCode";
    private static final String XPATH_ERRORSECTION_FATALERROR = "/examsdata:RequestsAndExamsData/errorSection/fatalErrors/fatalError";
    private static final String XPATH_EXAMREQUESTS2507 = "/examsdata:RequestsAndExamsData/patients/patient/examRequests/examRequest";
    private static final String XPATH_EXAMS2507 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam";
    
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_LINE1 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/line1";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_LINE2 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/line2";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_LINE3 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/line3";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_CITY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/city";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_POSTAL_CODE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/postalCode";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_STATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/state";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_COUNTRY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/country";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_COUNTY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/county";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_PROVINCE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/province";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_PHONE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/phone";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_WORK_PHONE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/workPhone";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_ZIP4 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/address/zip4";
    private static final String XPATH_EXAMS2507_VETERAN_ADDRESS_CHG_DATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/permanentAddress/lastPermanentAdressChangeDate/literal";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_ACTIVE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddressActive";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE1 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/line1";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE2 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/line2";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE3 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/line3";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_CITY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/city";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_POSTAL_CODE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/postalCode";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_STATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/state";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_COUNTRY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/country";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_COUNTY = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/county";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_PROVINCE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/province";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_PHONE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/phone";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_ZIP4 = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/address/zip4";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_CHG_DATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/lastTemporaryAdressChangeDate/literal";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_START_DATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/startDate/literal";
    private static final String XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_END_DATE = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/veteranAddress/temporaryAddress/endDate/literal";
    private static final String XPATH_EXAMS2507_COMMENTS = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/comments";
    private static final String XPATH_EXAMS2507_NEXTOFKIN = "/examsdata:RequestsAndExamsData/patients/patient/exams/exam/nextOfKin";
    private static final String XPATH_ERRORSECTION_WARNING = "/examsdata:RequestsAndExamsData/errorSection/warnings/warning";

    @Resource
    private RequestProcessorInterface rpcRequestProcessor = null;
    protected TemplateRequestProcessor templateRequestProcessor;


    @Before
    @Suite( groups = { "checkintest" } )
    public void beforeEndToEndReadVrmTestClassSetUp( )
        throws Exception
    {
        templateRequestProcessor = ( TemplateRequestProcessor )getRpcRequestProcessor();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestMultiTest_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        //String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, "200982" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 3 );

        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        // build filter
        String filterXml1 = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument1 = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml1, resolvedPatients );

        List<Element> elementList1 = dataDocument1.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList1.size() == 2 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestNoDatesNoStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 3 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestWithDatesNoStatus_SingleSite( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 2 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestStartDateNoEndDate_SingleSite( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = null;
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 3 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestEndDateNoStartDate_SingleSite( )
        throws Exception
    {
        String startDate = null;
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 2 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestWithDatesAndStatus_SingleSite( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String requestStatus = "C"; //COMLETED, PRINTED BY RO

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, requestStatus ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 1 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestWithDatesAndMultiStatus_SingleSite( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String requestStatus = "C,P";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, requestStatus ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 2 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestNoDatesAndStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String requestStatus = "C"; //COMLETED, PRINTED BY RO

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, requestStatus ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 1 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestNoData_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_FAILING };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementList.size() == 0 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestPartialReadOneFailure_MultiSite( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String requestStatus = "C"; //COMLETED, PRINTED BY RO

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING_1 };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, requestStatus ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 1 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_DATA_SOURCE_FAILURE ) );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testVistaExamRequest_AllSitesFailure( )
        throws Exception
    {
        String startDate = "1995-01-01";
        String endDate = "1995-12-31";
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String requestStatus = "C"; //COMLETED, PRINTED BY RO

        // build resolved patients
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING_2 };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING_1 };
        String[][] patientIdentifiers = { vistaPatient503, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, startDate, endDate,
                        clientRequestInitiationTime, requestStatus ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> fatalNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalNodes.size() == 1 );

        Node fatalErrorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalErrorCodeNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED ) );
    }


    @Test
    @Suite( groups = { "brokentest" } )//TBD FIX THIS - data changed - why?
    public void testVistaExamNoDatesNoStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        //String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, "7204654" };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );
        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() == 9 );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestsAndExamsRead2NoDatesNoStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );
        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() > 0 );

        chkExam2507Data( dataDocument );
    }


    private void chkExam2507Data( Document dataDocument )
    {
        List<Element> elementList;
        
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_COMMENTS );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_CITY );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_ZIP4 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_COUNTY );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_STATE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_PHONE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_CHG_DATE );
        assertTrue( elementList.size() != 0 );
        
        //currently this data is not in vistA - Nov 15 2012
        /*
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_NEXTOFKIN );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_LINE1 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_LINE2 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_LINE3 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_POSTAL_CODE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_PROVINCE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_COUNTRY );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_ADDRESS_WORK_PHONE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_ACTIVE );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE1 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE2 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_LINE3 );
        assertTrue( elementList.size() != 0 );
        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_CITY );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_POSTAL_CODE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_ZIP4 );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_COUNTY );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_PROVINCE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_STATE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_COUNTRY );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_PHONE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_CHG_DATE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_START_DATE );
        assertTrue( elementList.size() != 0 );

        elementList = dataDocument.selectNodes( XPATH_EXAMS2507_VETERAN_TEMP_ADDRESS_END_DATE );
        assertTrue( elementList.size() != 0 );*/    
    }


    @Test
    @Suite( groups = { "brokentest" } )//TBD - FIX THIS - Data changed - why?
    public void testVistaExamWithDatesNoStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String startDate = "1995-12-01";
        String endDate = "1995-12-31";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() == 5 );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestsAndExamsRead2WithDatesNoStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String startDate = "1995-12-01";
        String endDate = "1995-12-31";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() > 0 );

        chkExam2507Data( dataDocument );
    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testVistaExamWithDatesAndStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String startDate = "1995-12-01";
        String endDate = "1995-12-31";
        String status = "C";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime, status ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() == 5 );

    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testRequestsAndExamsRead2WithDatesAndStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String startDate = "1995-12-01";
        String endDate = "1995-12-31";
        String status = "C";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, startDate, endDate, clientRequestInitiationTime, status ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() > 0 );

        chkExam2507Data( dataDocument );
    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testVistaExamNoDatesAndStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String status = "C";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, status ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() == 9 );

    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testRequestsAndExamsRead2NoDatesAndStatus_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String status = "C";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, status ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() > 0 );

        chkExam2507Data( dataDocument );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamNoData_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_FAILING };
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementList = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementList.size() == 0 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamPartialReadOneFailure_MultiSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String status = "C";

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING_1 };
        String[][] patientIdentifiers = { vistaPatient580, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, status ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 1 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_DATA_SOURCE_FAILURE ) );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testVistaExam_AllSitesFailure( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();
        String status = "C";

        // build resolved patients
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING_2 };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING_1 };
        String[][] patientIdentifiers = { vistaPatient503, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );
        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamsFilterElementWithResolvedIdentfiers( TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER,
                        entryPointFilterMaps, resolvedPatients, null, null, clientRequestInitiationTime, status ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( warningNodes.size() == 1 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED ) );
    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testVistaExamRequestsAndExam_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() == 9 );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() == 3 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestsAndExamsRead2ExamRequestsAndExam_SingleSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() > 0 );

        chkExam2507Data( dataDocument );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() > 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testVistaExamRequestsAndExam_MultiSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient578_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2, vistaPatient578_1 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() == 15 );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() == 6 );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestsAndExamsRead2ExamRequestsAndExam_MultiSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient578_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA_EXAM };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2, vistaPatient578_1 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        Document dataDocument = readAndAssertDomainData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId, filterXml, resolvedPatients );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() > 0 );

        chkExam2507Data( dataDocument );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() > 0 );
    }


    @Test
    @Suite( groups = { "brokentest" } ) //Fix this - Data Changed - why?
    public void testVistaExamRequestsAndExam_PartialRead_MultiSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient578_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING_2 };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2, vistaPatient578_1, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() == 15 );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() == 6 );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 2 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_DATA_SOURCE_FAILURE ) );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testRequestsAndExamsRead2ExamRequestsAndExam_PartialRead_MultiSite( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
        String[] vistaPatient580_2 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient578_1 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_578, PATIENT_IDENTITY_VISTA_EXAM };
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING_2 };
        String[][] patientIdentifiers = { vistaPatient580_1, vistaPatient580_2, vistaPatient578_1, vistaPatient503 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID_2, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() > 0 );

        chkExam2507Data( dataDocument );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() > 0 );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> warningNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_WARNING );
        Assert.assertTrue( warningNodes.size() == 2 );

        Node errorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_WARNINGERRORCODE );
        Assert.assertTrue( errorCodeNode.getText().contains( READ_REQUEST_DATA_SOURCE_FAILURE ) );
    }


    @Test
    @Suite( groups = { "brokentest" } )
    public void testVistaExamRequestsAndExam_AllSitesFailure( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient503 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_2, PATIENT_IDENTITY_VISTA_FAILING_2 };
        String[] vistaPatient504 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNINGFACILITY_FAILURE_1, PATIENT_IDENTITY_VISTA_FAILING_1 };
        String[][] patientIdentifiers = { vistaPatient503, vistaPatient504 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();

        templateRequestProcessor.setValidateReadResponseXML( false );
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml,
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        assertNotNull( dataDocument );

        List<Element> elementListExams = dataDocument.selectNodes( XPATH_EXAMS2507 );
        assertTrue( elementListExams.size() == 0 );

        List<Element> elementListExamRequests = dataDocument.selectNodes( XPATH_EXAMREQUESTS2507 );
        assertTrue( elementListExamRequests.size() == 0 );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> fatalNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalNodes.size() == 1 );
        Node fatalErrorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalErrorCodeNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED ) );

        Node fatalErrorDisplayMsgtNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE_DISPLAYMSG );
        Assert.assertTrue( fatalErrorDisplayMsgtNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED_MSG ) );
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestsAndExamInvalidTemplateId( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, "580", PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
       
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();
        Document dataDocument = templateRequestProcessor.readClinicalData( "XYZ", filterXml, TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
 
        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

    }

 
    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestsAndExamInvalidFacility( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, "X1", PATIENT_IDENTITY_VISTA_EXAM_REQUEST };
       
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml, TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
   
        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testVistaExamRequestsAndExamInvalidDFN( )
        throws Exception
    {
        String clientRequestInitiationTime = "2011-06-06T12:01:01Z";
        String requestId = TemplateIdHelper.getUniqueIdentifier();

        // build resolved patients
        String[] vistaPatient580 = { ASSIGNING_AUTHORITY_VISTA, ASSIGNING_FACILITY_VISTA_580, "123456" };
       
        String[][] patientIdentifiers = { vistaPatient580 };
        List<Map<String, String>> resolvedPatients = getResolvedPatients( patientIdentifiers );

        // build entry point 
        Map<String, String> entryPointFilterMapRequests = new HashMap<String, String>();
        entryPointFilterMapRequests.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "ExamRequest2507" );
        entryPointFilterMapRequests.put( FilterBuilder.QUERY_NAME_KEY, "ExamRequest2507-Standardized" );

        Map<String, String> entryPointFilterMapExams = new HashMap<String, String>();
        entryPointFilterMapExams.put( FilterBuilder.DOMAIN_ENTRYPOINT_KEY, "Exam2507" );
        entryPointFilterMapExams.put( FilterBuilder.QUERY_NAME_KEY, "Exam2507-Standardized" );

        List<Map<String, String>> entryPointFilterMaps = new ArrayList<Map<String, String>>();
        entryPointFilterMaps.add( entryPointFilterMapRequests );
        entryPointFilterMaps.add( entryPointFilterMapExams );

        // build filter
        String filterXml = FilterBuilder.buildExamRequestsFilterElementWithResolvedIdentfiers(
                        TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, entryPointFilterMaps, resolvedPatients, null, null,
                        clientRequestInitiationTime, null ).asXML();
        Document dataDocument = templateRequestProcessor.readClinicalData( TemplateIdHelper.REQUESTS_EXAMS_READ_TEMPLATE_ID, filterXml, TemplateIdHelper.REQUESTS_AND_EXAMS_SINGLE_PATIENT_FILTER, requestId );
        
        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 1 );

        //make sure we reported one  READ_REQUEST_DATA_SOURCE_FAILURE successfully as a warning
        List<Node> fatalNodes = dataDocument.selectNodes( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalNodes.size() == 1 );
        Node fatalErrorCodeNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE );
        Assert.assertTrue( fatalErrorCodeNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED ) );

        Node fatalErrorDisplayMsgtNode = dataDocument.selectSingleNode( XPATH_EXAMREQUEST_ERRORSECTION_FATALERRORCODE_DISPLAYMSG );
        Assert.assertTrue( fatalErrorDisplayMsgtNode.getText().contains( READ_REQUEST_ALL_DATA_SOURCES_FAILED_MSG ) );
    }

    protected Document readAndAssertDomainData( String templateId, String filterId, String requestId, String filterXml,
                    List<Map<String, String>> resolvedPatients )
        throws Exception
    {
        templateRequestProcessor.setValidateReadResponseXML( true );
        Document dataDocument = templateRequestProcessor.readClinicalData( templateId, filterXml, filterId, requestId );
        assertNotNull( dataDocument );

        // Check for error sections
        List<Element> errorSections = dataDocument.selectNodes( XPATH_ERRORSECTION );
        assertTrue( errorSections.size() == 0 );

        // Check for domain entry point elements
        List<Element> domainElements = dataDocument.selectNodes( XPATH_PATIENT );
        assertTrue( domainElements.size() > 0 );

        // Assert that the resolved identifier assigning facility values from the filter are in the result document
        List<Element> resultsResolvedIdentifiersList = dataDocument.selectNodes( CDS_XPATH_IDENTIFIERS );
        assertTrue( resultsResolvedIdentifiersList.size() == resolvedPatients.size() );
        for ( Element resultsResolvedIdentifiers : resultsResolvedIdentifiersList )
        {
            String resultsAssigningAuthority = resultsResolvedIdentifiers.selectSingleNode( XPATH_ASSIGNING_AUTHORITY_ELEMENT_NAME ).getText();
            String resultsAssigningFacility = resultsResolvedIdentifiers.selectSingleNode( XPATH_ASSIGNING_FACILITY_ELEMENT_NAME ).getText();
            String resultsPatientIdentity = resultsResolvedIdentifiers.selectSingleNode( XPATH_PATIENT_IDENTITY_ELEMENT_NAME ).getText();

            Map<String, String> assigningAuthorityFacilityAndPatientIdentityMap = null;
            for ( Map<String, String> resolvedPatientMap : resolvedPatients )
            {
                String mapAssigningAuthority = resolvedPatientMap.get( FilterBuilder.ASSIGNING_AUTHORITY_KEY );
                String mapAssigningFacility = resolvedPatientMap.get( FilterBuilder.ASSIGNING_FACILITY );
                String mapIdentity = resolvedPatientMap.get( FilterBuilder.IDENTITY );
                if ( mapAssigningAuthority != null && mapAssigningAuthority.equalsIgnoreCase( resultsAssigningAuthority )
                                && mapAssigningFacility != null && mapAssigningFacility.equalsIgnoreCase( resultsAssigningFacility )
                                && mapIdentity != null && mapIdentity.equalsIgnoreCase( resultsPatientIdentity ) )
                {
                    assigningAuthorityFacilityAndPatientIdentityMap = resolvedPatientMap;
                    break;
                }
            }

            assertNotNull( assigningAuthorityFacilityAndPatientIdentityMap );
            String mapPatientIdentity = assigningAuthorityFacilityAndPatientIdentityMap.get( FilterBuilder.IDENTITY );
            assertNotNull( mapPatientIdentity );
            assertTrue( mapPatientIdentity.equals( resultsPatientIdentity ) );
        }

        return dataDocument;
    }


    protected RequestProcessorInterface getRpcRequestProcessor( )
    {
        return rpcRequestProcessor;
    }
}
