

package gov.va.med.cds.filter;


import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;

import org.junit.Test;
import org.junit.runner.RunWith;


/**
 * 
 * Testing concurrent processing
 * 
 * 
 */
@RunWith( SuiteAwareSpringRunner.class )
public class ConcurrentFilterTest
    extends
        AbstractConcurrentFilterTest
{
    
    @Override
    @Test
    @Suite( groups = { "smoketest" } )
    public void performFilterManagerOperation( )
        throws Exception
    {

        long runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String filter : lessFiltersThanCache )
            {
                getFilterManager().validateFilterXml( filter,
                                getFilterXml( filter, filterMap.get( filter ).get( 0 ), filterMap.get( filter ).get( 1 ) ) );
            }
        }

        runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String filter : sameFiltersAsCache )
            {
                getFilterManager().validateFilterXml( filter,
                                getFilterXml( filter, filterMap.get( filter ).get( 0 ), filterMap.get( filter ).get( 1 ) ) );
            }
        }

        runToTimeInMilliSeconds = System.currentTimeMillis() + RUN_TIME_IN_MILLI_SECONDS;

        while ( System.currentTimeMillis() < runToTimeInMilliSeconds )
        {
            for ( String filter : moreFiltersThanCache )
            {
                getFilterManager().validateFilterXml( filter,
                                getFilterXml( filter, filterMap.get( filter ).get( 0 ), filterMap.get( filter ).get( 1 ) ) );
            }
        }

    }

}
