

package gov.va.med.cds.xml.schema;


import org.eclipse.xsd.XSDSchema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.validation.Validator;


/**
 *
 * Gets the xml validator, meta data and symbol map.
 *
 */
public interface SchemaHelperInterface
{

    /**
     * Gets the validator.
     *
     * @return New instance of the java XML Validator.
     */
    Validator getValidator( );


    /**
     * Gets the template id associated with the schema.
     *
     * @return template id.
     */
    //Joey 01/14/2008    String getTemplateId();
    /**
     * Gets the symbol map.
     *
     * @return Map of
     */
    Map<String, List<String>> getSymbolMap( );
    
    //Used in tools/vhim-artifacts-validation project
    ArrayList<XSDSchema> getXsdSchemasList( );
}
