

package gov.va.med.cds.transaction;


import commonj.work.RemoteWorkItem;
import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;
import commonj.work.WorkManager;

import java.util.List;


public class SpringWorkManagerScheduler
    implements
        WorkManagerInterface
{
    private WorkManager workManager;


    public WorkItem schedule( Work work )
        throws WorkException
    {
        WorkItem workItem = null;
        workItem = workManager.schedule( work );

        return workItem;
    }


    @Override
    public boolean waitForAll( List<? extends WorkItem> workItems )
        throws WorkException
    {
        return waitForAll( workItems, WorkManager.INDEFINITE );
    }


    /***
     * returns boolean true if work manager timed out
     */
    public boolean waitForAll( List<? extends WorkItem> jobs, long timeout )
        throws WorkException
    {
        boolean timeOut = true;

        try
        {
            // true if all WorkItems have completed, false if the timeout has expired. 
            timeOut = workManager.waitForAll( jobs, timeout );
        }
        catch ( InterruptedException e )
        {
            throw new WorkException( "Work interrupted.", e );
        }

        return timeOut;
    }


    public void setWorkManager( WorkManager workManager )
    {
        this.workManager = workManager;
    }
}
