/**
 * 
 */


package gov.va.med.cds.transaction;


import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.ReadPersistenceManagerInterface;

import java.util.List;

import org.dom4j.Document;

import commonj.work.Work;


/**
 * @author vhaislegberb
 *
 */
public class ReadWork
    implements
        Work
{
    private ReadPersistenceManagerInterface persistenceManager;
    private EntryFilterInterface entryFilter;
    private List<PersonIdentifierInterface> personIdentifiers;

    private boolean completeFailure = false;
    private Document result = null;
    private String cdsAppName;


    /**
     * Constructor for read work class.
     * @param persistenceManager The persistence manager to use for the read operation.
     * @param entryFilter The entry filter which contains information needed for the read to happen.
     * @param uniqueIdentifier The unique identifier for the read operation (request identifier).
     * @param personIdentifiers The list of person identifiers to be queried during the read operation.
     * @param templateId The template identifier that is needed for query customization.
     */
    public ReadWork( ReadPersistenceManagerInterface persistenceManager, EntryFilterInterface entryFilter,
                    List<PersonIdentifierInterface> personIdentifiers )
    {
        this.persistenceManager = persistenceManager;
        this.entryFilter = entryFilter;
        this.personIdentifiers = personIdentifiers;
    }


    /*
     * (non-Javadoc)
     * @see commonj.work.Work#release()
     */
    public void release( )
    {
        // no-op for now.
    }


    /*
     * (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run( )
    {
        try
        {
            result = persistenceManager.performReadOnClinicalData( entryFilter, personIdentifiers, cdsAppName );
        }
        catch ( PersistenceException e )
        {
            // do nothing, since everything was already recorded in method.
            // we just want to record if there was a problem or not.
            completeFailure = true;
            result = ExceptionHandler.handleException( result, e, entryFilter.getTemplateId(), entryFilter.getRequestId(), cdsAppName );
        }
    }


    /**
     * Gets the indicator of whether the read work failed completely.
     * @return True if the read operation failed in totality; otherwise false.
     */
    public boolean isCompleteFailure( )
    {
        return completeFailure;
    }


    /**
     * Gets the results from the read work.
     * @return The list of results from the read work.
     */
    public Document getResult( )
    {
        return result;
    }


    /**
     * Sets the results from the read work.
     * Useful internally for unit testing.
     */
    protected void setResult( Document result )
    {
        this.result = result;
    }


    /*
     * (non-Javadoc)
     * @see commonj.work.Work#isDaemon()
     */
    public boolean isDaemon( )
    {
        return false;
    }


    public void setCdsAppName( String cdsAppName )
    {
        this.cdsAppName = cdsAppName;
    }
}
