

package gov.va.med.cds.template;


import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.response.PatientIdentifierDocumentBuilderInterface;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.response.organizer.ResponseOrganizerInterface;
import gov.va.med.cds.response.sequencer.ResponseSequencerInterface;

import java.util.Map;


/**
 * @author susarlan
 *
 */
public class TemplateHelper
    implements
        TemplateHelperInterface
{
	private static final String APP_NAME_KEY = "applicationName";
	
    private Map<String, Map<String, Object>> templateDependentObjectsMap;
    
    private String defaultApplicationName = null;


    /***
     * Get the WriteResponseBuilderInterface to be used for building a
     * successful write response based on the given template id.  
     * 
     * @param templateId
     * @return WriteResponseGeneratorInterface
     */
    public WriteResponseGeneratorInterface getWriteResponseGenerator( String templateId )
    {

        WriteResponseGeneratorInterface writeResponseGenerator = ( WriteResponseGeneratorInterface )templateDependentObjectsMap.get( templateId )
                        .get( WriteResponseGeneratorInterface.class.getName() );
        if ( writeResponseGenerator == null )
        {
            throw new RuntimeException( "No write response generator configured for " + templateId );
        }
        return writeResponseGenerator;
    }


    /***
     * Get the ErrorSectionHelperInterface to be used for building an
     * error section based on the given template id.  
     * 
     * @param templateId
     * @return ErrorSectionHelperInterface
     */
    public ErrorSectionHelperInterface getErrorSectionHelper( String templateId )
    {
        Map<String, Object> objectsMap = templateDependentObjectsMap.get( templateId );
        if ( objectsMap != null )
        {
            return ( ErrorSectionHelperInterface )objectsMap.get( ErrorSectionHelperInterface.class.getName() );
        }
        else
        {
            return null;
        }
    }


    /***
     * Get the ResponseAggregatorInterface to be used for aggregating the
     * responses based on the given template id.  
     * 
     * @param templateId
     * @return ResponseAggregatorInterface
     */
    public ResponseAggregatorInterface getResponseAggregator( String templateId )
    {
        return ( ResponseAggregatorInterface )( templateDependentObjectsMap.get( templateId ).get( ResponseAggregatorInterface.class.getName() ) );
    }


    /***
     * Get the ResponseSequencerInterface to be used for sequencing the
     * responses based on the given template id.  
     * 
     * @param templateId
     * @return ResponseSequencerInterface
     */
    public ResponseSequencerInterface getResponseSequencer( String templateId )
    {
        return ( ResponseSequencerInterface )( templateDependentObjectsMap.get( templateId ).get( ResponseSequencerInterface.class.getName() ) );
    }


    public void setTemplateDependentObjectsMap( Map<String, Map<String, Object>> templateDependentObjectsMap )
    {
        this.templateDependentObjectsMap = templateDependentObjectsMap;
    }
    
    
    public void setDefaultApplicationName(String defaultApplicationName) 
    {
		this.defaultApplicationName = defaultApplicationName;
	}

    /**
     * Get the PatientIdentifierDocumentBuilderInterface to be used for
     * building a Document with Patient search identifier data which
     * will be aggregated into the final response.
     * 
     * @param templateId
     * @return PatientIdentifierDocumentBuilderInterface
     */
    public PatientIdentifierDocumentBuilderInterface getPatientIdentifierDocumentBuilder( String templateId )
    {
        return ( PatientIdentifierDocumentBuilderInterface )( templateDependentObjectsMap.get( templateId )
                        .get( PatientIdentifierDocumentBuilderInterface.class.getName() ) );
    }


    /**
     * Get the ResponseOrganizer to be used for ordering the
     * responses based on the given template id. 
     * @param templateId
     *  
     * @return ResponseOrganizerInterface
     */
    public ResponseOrganizerInterface getResponseOrganizer( String templateId )
    {
        ResponseOrganizerInterface organizer = null;
        Map<String, Object> mapEntry = templateDependentObjectsMap.get( templateId );
        if ( mapEntry != null )
        {
            organizer = ( ResponseOrganizerInterface )mapEntry.get( ResponseOrganizerInterface.class.getName() );
        }
        return organizer;
    }
    
    @Override
    /*
     * (non-Javadoc)
     * @see gov.va.med.cds.template.TemplateHelperInterface#getApplicationName(java.lang.String)
     */
    public String getApplicationName(String templateId) {
    	Map<String, Object> mapEntry = templateDependentObjectsMap.get( templateId );
        return (mapEntry != null && mapEntry.get(APP_NAME_KEY) != null) ? ( String )mapEntry.get( APP_NAME_KEY ) : defaultApplicationName;
    }
}