

package gov.va.med.cds.template;


import gov.va.med.cds.clinicaldata.TemplateMetaDataInterface;
import gov.va.med.cds.xml.schema.SchemaHelperInterface;

import org.springframework.core.io.Resource;

import java.io.IOException;
import java.util.Set;


public interface TemplateCacheInterface
{

    /**
     * returns schema helper class for a given template id
     * 
     * @param aTemplateId
     * @return SchemaHelperInterface
     */
    SchemaHelperInterface getSchemaHelper( String aTemplateId );


    // Collection<SchemaHelperInterface> getAllSchemaHelpers( );

    /**
     * returns template meta data class for a given template id
     * 
     * @param templateId
     * @return TemplateMetaDataInterface
     */
    TemplateMetaDataInterface getTemplateMetaData( String templateId );


    /**
     * @return True if the template cache is empty.
     */
    boolean isEmpty( );


    /**
     * Clears the template cache.
     */
    void clear( );


    /**
     * Resizes the template cache to the given size.
     * 
     * @param newSize
     */
    void reSize( int newSize );


    /**
     * Gets the no. of schemas contained in template cache
     * 
     * @return number of templates
     */
    int getNumberOfTemplatesLoadedIntoTemplateCache( );


    /**
     * Gets the size of template cache threshold.
     * 
     * @return templateCacheThreshold value
     */
    int getTemplateCacheThreshold( );


    /**
     * gets available list of templateIds in template cache
     * 
     * @return Set of templateIds
     */
    Set<String> getTemplateCacheTemplateIds( );


    /**
     * Loads the map with the given pair of templateId and templateMetadata.
     * 
     * @param aSchemaResource
     * @param templateMetaData
     * @throws IOException
     */
    void loadSchemaIntoCache( TemplateMetaDataInterface templateMetaData )
        throws IOException;
}
