/**
 * 
 */


package gov.va.med.cds.response.strategy;


import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.List;


/**
 * @author vhaislbloyed
 *
 */
public class VistaGenericStoredProcedureResponseStrategy
    implements
        VistaGenericStoredProcedureResponseStrategyInterface
{

    @Override
    public Element formatResponse( List<String> records, String patientId, String siteId )
        throws Exception
    {
        Element results = DocumentHelper.createElement( "results" );

        for ( String value : records )
        {
            Element genericObservationElement = DocumentHelper.createElement( "genericObservation" );

            // <recordIdentifier>
            Element recordIdentifierElement = DocumentHelper.createElement( "recordIdentifier" );
            Element identityElement = DocumentHelper.createElement( "identity" );
            identityElement.setText( patientId );
            recordIdentifierElement.add( identityElement );

            if ( siteId != null && !"".equals( siteId ) )
            {
                Element namespaceIdElement = DocumentHelper.createElement( "namespaceId" );
                namespaceIdElement.setText( siteId );
                recordIdentifierElement.add( namespaceIdElement );
            }

            genericObservationElement.add( recordIdentifierElement );

            // <observationValue>
            Element observationValueElement = DocumentHelper.createElement( "observationValue" );
            observationValueElement.addCDATA( value.trim() );
            genericObservationElement.add( observationValueElement );
            results.add( genericObservationElement );
        }

        return results;
    }

}
