package gov.va.med.cds.request.vista.write;

import java.util.List;

import org.dom4j.Element;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;
import gov.va.med.cds.filter.EntryFilterInterface;

public interface CdsWriteInterface {

	//public int getDocumentsSize();
	
	/**
	 * Gets person ids from the write request.
	 * 
	 * @return person ids from the write request
	 */
	public List<PersonIdentifierInterface> getPersonIdentifiers();
	
	/**
	 * Gets the write request data.
	 * 
	 * @return write data from the write request
	 */
	public List<EntryFilterInterface> getCreateData();
	
	/**
	 * Gets the domain entry point of the write request.
	 * 
	 * @return domain entry point
	 */
	public String getDomainEntryPoint(); 

	/**
	 * Gets the request identifier for the write request.
	 * 
	 * @return request id.
	 */
	public String getRequestId();

	/**
	 * Gets the template identifier for the write request.
	 * 
	 * @return The template identifier.
	 */
	public String getTemplateId();
	
	public void setDataElement(Element parentDataElement);

	public void setDomainEntryPoint(DomainEntryPoint domainEntryPoint);

	public void setTemplateId(String templateId); 
	
	public void setRequestId(String requestId);
	
	public void setEntryPointElement(String entryPointElement);
	
	public void extractData();
}
